// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



class ListDeploymentTargetsRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A token identifier returned from the previous ListDeploymentTargets
     * call. It can be used to return the next set of deployment targets in the list.
     */
    val nextToken: String? = builder.nextToken
    /**
     * A key used to filter the returned targets. The two valid values are:
     * TargetStatus - A TargetStatus filter string can be
     * Failed, InProgress, Pending,
     * Ready, Skipped, Succeeded, or
     * Unknown.
     * ServerInstanceLabel - A ServerInstanceLabel filter
     * string can be Blue or Green.
     */
    val targetFilters: Map<String, List<String>>? = builder.targetFilters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDeploymentTargetsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeploymentTargetsRequest(")
        append("deploymentId=$deploymentId,")
        append("nextToken=$nextToken,")
        append("targetFilters=$targetFilters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (targetFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDeploymentTargetsRequest

        if (deploymentId != other.deploymentId) return false
        if (nextToken != other.nextToken) return false
        if (targetFilters != other.targetFilters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDeploymentTargetsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDeploymentTargetsRequest
        /**
         * The unique ID of a deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A token identifier returned from the previous ListDeploymentTargets
         * call. It can be used to return the next set of deployment targets in the list.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * A key used to filter the returned targets. The two valid values are:
         * TargetStatus - A TargetStatus filter string can be
         * Failed, InProgress, Pending,
         * Ready, Skipped, Succeeded, or
         * Unknown.
         * ServerInstanceLabel - A ServerInstanceLabel filter
         * string can be Blue or Green.
         */
        fun targetFilters(targetFilters: Map<String, List<String>>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: String?
        /**
         * A token identifier returned from the previous ListDeploymentTargets
         * call. It can be used to return the next set of deployment targets in the list.
         */
        var nextToken: String?
        /**
         * A key used to filter the returned targets. The two valid values are:
         * TargetStatus - A TargetStatus filter string can be
         * Failed, InProgress, Pending,
         * Ready, Skipped, Succeeded, or
         * Unknown.
         * ServerInstanceLabel - A ServerInstanceLabel filter
         * string can be Blue or Green.
         */
        var targetFilters: Map<String, List<String>>?

        fun build(): ListDeploymentTargetsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var nextToken: String? = null
        override var targetFilters: Map<String, List<String>>? = null

        constructor(x: ListDeploymentTargetsRequest) : this() {
            this.deploymentId = x.deploymentId
            this.nextToken = x.nextToken
            this.targetFilters = x.targetFilters
        }

        override fun build(): ListDeploymentTargetsRequest = ListDeploymentTargetsRequest(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun targetFilters(targetFilters: Map<String, List<String>>): FluentBuilder = apply { this.targetFilters = targetFilters }
    }
}
