// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a ListDeployments operation.
 */
class ListDeploymentsRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS
     * account.
     * If applicationName is specified, then
     * deploymentGroupName must be specified. If it is not specified, then
     * deploymentGroupName must not be specified.
     */
    val applicationName: String? = builder.applicationName
    /**
     * A time range (start and end) for returning a subset of the list of deployments.
     */
    val createTimeRange: TimeRange? = builder.createTimeRange
    /**
     * The name of a deployment group for the specified application.
     * If deploymentGroupName is specified, then
     * applicationName must be specified. If it is not specified, then
     * applicationName must not be specified.
     */
    val deploymentGroupName: String? = builder.deploymentGroupName
    /**
     * The unique ID of an external resource for returning deployments linked to the external
     * resource.
     */
    val externalId: String? = builder.externalId
    /**
     * A subset of deployments to list by status:
     * Created: Include created deployments in the resulting
     * list.
     * Queued: Include queued deployments in the resulting list.
     * In Progress: Include in-progress deployments in the resulting
     * list.
     * Succeeded: Include successful deployments in the resulting
     * list.
     * Failed: Include failed deployments in the resulting list.
     * Stopped: Include stopped deployments in the resulting
     * list.
     */
    val includeOnlyStatuses: List<DeploymentStatus>? = builder.includeOnlyStatuses
    /**
     * An identifier returned from the previous list deployments call. It can be used to
     * return the next set of deployments in the list.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDeploymentsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeploymentsRequest(")
        append("applicationName=$applicationName,")
        append("createTimeRange=$createTimeRange,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("externalId=$externalId,")
        append("includeOnlyStatuses=$includeOnlyStatuses,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (createTimeRange?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (includeOnlyStatuses?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDeploymentsRequest

        if (applicationName != other.applicationName) return false
        if (createTimeRange != other.createTimeRange) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (externalId != other.externalId) return false
        if (includeOnlyStatuses != other.includeOnlyStatuses) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDeploymentsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDeploymentsRequest
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         * If applicationName is specified, then
         * deploymentGroupName must be specified. If it is not specified, then
         * deploymentGroupName must not be specified.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * A time range (start and end) for returning a subset of the list of deployments.
         */
        fun createTimeRange(createTimeRange: TimeRange): FluentBuilder
        /**
         * The name of a deployment group for the specified application.
         * If deploymentGroupName is specified, then
         * applicationName must be specified. If it is not specified, then
         * applicationName must not be specified.
         */
        fun deploymentGroupName(deploymentGroupName: String): FluentBuilder
        /**
         * The unique ID of an external resource for returning deployments linked to the external
         * resource.
         */
        fun externalId(externalId: String): FluentBuilder
        /**
         * A subset of deployments to list by status:
         * Created: Include created deployments in the resulting
         * list.
         * Queued: Include queued deployments in the resulting list.
         * In Progress: Include in-progress deployments in the resulting
         * list.
         * Succeeded: Include successful deployments in the resulting
         * list.
         * Failed: Include failed deployments in the resulting list.
         * Stopped: Include stopped deployments in the resulting
         * list.
         */
        fun includeOnlyStatuses(includeOnlyStatuses: List<DeploymentStatus>): FluentBuilder
        /**
         * An identifier returned from the previous list deployments call. It can be used to
         * return the next set of deployments in the list.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS
         * account.
         * If applicationName is specified, then
         * deploymentGroupName must be specified. If it is not specified, then
         * deploymentGroupName must not be specified.
         */
        var applicationName: String?
        /**
         * A time range (start and end) for returning a subset of the list of deployments.
         */
        var createTimeRange: TimeRange?
        /**
         * The name of a deployment group for the specified application.
         * If deploymentGroupName is specified, then
         * applicationName must be specified. If it is not specified, then
         * applicationName must not be specified.
         */
        var deploymentGroupName: String?
        /**
         * The unique ID of an external resource for returning deployments linked to the external
         * resource.
         */
        var externalId: String?
        /**
         * A subset of deployments to list by status:
         * Created: Include created deployments in the resulting
         * list.
         * Queued: Include queued deployments in the resulting list.
         * In Progress: Include in-progress deployments in the resulting
         * list.
         * Succeeded: Include successful deployments in the resulting
         * list.
         * Failed: Include failed deployments in the resulting list.
         * Stopped: Include stopped deployments in the resulting
         * list.
         */
        var includeOnlyStatuses: List<DeploymentStatus>?
        /**
         * An identifier returned from the previous list deployments call. It can be used to
         * return the next set of deployments in the list.
         */
        var nextToken: String?

        fun build(): ListDeploymentsRequest
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TimeRange] inside the given [block]
         */
        fun createTimeRange(block: TimeRange.DslBuilder.() -> kotlin.Unit) {
            this.createTimeRange = TimeRange.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationName: String? = null
        override var createTimeRange: TimeRange? = null
        override var deploymentGroupName: String? = null
        override var externalId: String? = null
        override var includeOnlyStatuses: List<DeploymentStatus>? = null
        override var nextToken: String? = null

        constructor(x: ListDeploymentsRequest) : this() {
            this.applicationName = x.applicationName
            this.createTimeRange = x.createTimeRange
            this.deploymentGroupName = x.deploymentGroupName
            this.externalId = x.externalId
            this.includeOnlyStatuses = x.includeOnlyStatuses
            this.nextToken = x.nextToken
        }

        override fun build(): ListDeploymentsRequest = ListDeploymentsRequest(this)
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun createTimeRange(createTimeRange: TimeRange): FluentBuilder = apply { this.createTimeRange = createTimeRange }
        override fun deploymentGroupName(deploymentGroupName: String): FluentBuilder = apply { this.deploymentGroupName = deploymentGroupName }
        override fun externalId(externalId: String): FluentBuilder = apply { this.externalId = externalId }
        override fun includeOnlyStatuses(includeOnlyStatuses: List<DeploymentStatus>): FluentBuilder = apply { this.includeOnlyStatuses = includeOnlyStatuses }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
