// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the Elastic Load Balancing load balancer or target group used in a
 * deployment.
 */
class LoadBalancerInfo private constructor(builder: BuilderImpl) {
    /**
     * An array that contains information about the load balancer to use for load balancing
     * in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load
     * Balancers.
     * Adding more than one load balancer to the array is not supported.
     */
    val elbInfoList: List<ElbInfo>? = builder.elbInfoList
    /**
     * An array that contains information about the target group to use for load balancing in
     * a deployment. In Elastic Load Balancing, target groups are used with Application Load
     * Balancers.
     * Adding more than one target group to the array is not supported.
     */
    val targetGroupInfoList: List<TargetGroupInfo>? = builder.targetGroupInfoList
    /**
     * The target group pair information. This is an array of
     * TargeGroupPairInfo objects with a maximum size of one.
     */
    val targetGroupPairInfoList: List<TargetGroupPairInfo>? = builder.targetGroupPairInfoList

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LoadBalancerInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerInfo(")
        append("elbInfoList=$elbInfoList,")
        append("targetGroupInfoList=$targetGroupInfoList,")
        append("targetGroupPairInfoList=$targetGroupPairInfoList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = elbInfoList?.hashCode() ?: 0
        result = 31 * result + (targetGroupInfoList?.hashCode() ?: 0)
        result = 31 * result + (targetGroupPairInfoList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LoadBalancerInfo

        if (elbInfoList != other.elbInfoList) return false
        if (targetGroupInfoList != other.targetGroupInfoList) return false
        if (targetGroupPairInfoList != other.targetGroupPairInfoList) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LoadBalancerInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LoadBalancerInfo
        /**
         * An array that contains information about the load balancer to use for load balancing
         * in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load
         * Balancers.
         * Adding more than one load balancer to the array is not supported.
         */
        fun elbInfoList(elbInfoList: List<ElbInfo>): FluentBuilder
        /**
         * An array that contains information about the target group to use for load balancing in
         * a deployment. In Elastic Load Balancing, target groups are used with Application Load
         * Balancers.
         * Adding more than one target group to the array is not supported.
         */
        fun targetGroupInfoList(targetGroupInfoList: List<TargetGroupInfo>): FluentBuilder
        /**
         * The target group pair information. This is an array of
         * TargeGroupPairInfo objects with a maximum size of one.
         */
        fun targetGroupPairInfoList(targetGroupPairInfoList: List<TargetGroupPairInfo>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An array that contains information about the load balancer to use for load balancing
         * in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load
         * Balancers.
         * Adding more than one load balancer to the array is not supported.
         */
        var elbInfoList: List<ElbInfo>?
        /**
         * An array that contains information about the target group to use for load balancing in
         * a deployment. In Elastic Load Balancing, target groups are used with Application Load
         * Balancers.
         * Adding more than one target group to the array is not supported.
         */
        var targetGroupInfoList: List<TargetGroupInfo>?
        /**
         * The target group pair information. This is an array of
         * TargeGroupPairInfo objects with a maximum size of one.
         */
        var targetGroupPairInfoList: List<TargetGroupPairInfo>?

        fun build(): LoadBalancerInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var elbInfoList: List<ElbInfo>? = null
        override var targetGroupInfoList: List<TargetGroupInfo>? = null
        override var targetGroupPairInfoList: List<TargetGroupPairInfo>? = null

        constructor(x: LoadBalancerInfo) : this() {
            this.elbInfoList = x.elbInfoList
            this.targetGroupInfoList = x.targetGroupInfoList
            this.targetGroupPairInfoList = x.targetGroupPairInfoList
        }

        override fun build(): LoadBalancerInfo = LoadBalancerInfo(this)
        override fun elbInfoList(elbInfoList: List<ElbInfo>): FluentBuilder = apply { this.elbInfoList = elbInfoList }
        override fun targetGroupInfoList(targetGroupInfoList: List<TargetGroupInfo>): FluentBuilder = apply { this.targetGroupInfoList = targetGroupInfoList }
        override fun targetGroupPairInfoList(targetGroupPairInfoList: List<TargetGroupPairInfo>): FluentBuilder = apply { this.targetGroupPairInfoList = targetGroupPairInfoList }
    }
}
