// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the location of an application revision.
 */
class RevisionLocation private constructor(builder: BuilderImpl) {
    /**
     * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
     * content is formatted as JSON or YAML and stored as a RawString.
     */
    val appSpecContent: AppSpecContent? = builder.appSpecContent
    /**
     * Information about the location of application artifacts stored in GitHub.
     */
    val gitHubLocation: GitHubLocation? = builder.gitHubLocation
    /**
     * The type of application revision:
     * S3: An application revision stored in Amazon S3.
     * GitHub: An application revision stored in GitHub (EC2/On-premises deployments
     * only).
     * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments
     * only).
     * AppSpecContent: An AppSpecContent object that contains the
     * contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
     * content is formatted as JSON or YAML stored as a RawString.
     */
    val revisionType: RevisionLocationType? = builder.revisionType
    /**
     * Information about the location of a revision stored in Amazon S3.
     */
    val s3Location: S3Location? = builder.s3Location
    /**
     * Information about the location of an AWS Lambda deployment revision stored as a
     * RawString.
     */
    val string: RawString? = builder.string

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RevisionLocation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RevisionLocation(")
        append("appSpecContent=$appSpecContent,")
        append("gitHubLocation=$gitHubLocation,")
        append("revisionType=$revisionType,")
        append("s3Location=$s3Location,")
        append("string=$string)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appSpecContent?.hashCode() ?: 0
        result = 31 * result + (gitHubLocation?.hashCode() ?: 0)
        result = 31 * result + (revisionType?.hashCode() ?: 0)
        result = 31 * result + (s3Location?.hashCode() ?: 0)
        result = 31 * result + (string?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RevisionLocation

        if (appSpecContent != other.appSpecContent) return false
        if (gitHubLocation != other.gitHubLocation) return false
        if (revisionType != other.revisionType) return false
        if (s3Location != other.s3Location) return false
        if (string != other.string) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RevisionLocation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RevisionLocation
        /**
         * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
         * content is formatted as JSON or YAML and stored as a RawString.
         */
        fun appSpecContent(appSpecContent: AppSpecContent): FluentBuilder
        /**
         * Information about the location of application artifacts stored in GitHub.
         */
        fun gitHubLocation(gitHubLocation: GitHubLocation): FluentBuilder
        /**
         * The type of application revision:
         * S3: An application revision stored in Amazon S3.
         * GitHub: An application revision stored in GitHub (EC2/On-premises deployments
         * only).
         * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments
         * only).
         * AppSpecContent: An AppSpecContent object that contains the
         * contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
         * content is formatted as JSON or YAML stored as a RawString.
         */
        fun revisionType(revisionType: RevisionLocationType): FluentBuilder
        /**
         * Information about the location of a revision stored in Amazon S3.
         */
        fun s3Location(s3Location: S3Location): FluentBuilder
        /**
         * Information about the location of an AWS Lambda deployment revision stored as a
         * RawString.
         */
        fun string(string: RawString): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
         * content is formatted as JSON or YAML and stored as a RawString.
         */
        var appSpecContent: AppSpecContent?
        /**
         * Information about the location of application artifacts stored in GitHub.
         */
        var gitHubLocation: GitHubLocation?
        /**
         * The type of application revision:
         * S3: An application revision stored in Amazon S3.
         * GitHub: An application revision stored in GitHub (EC2/On-premises deployments
         * only).
         * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments
         * only).
         * AppSpecContent: An AppSpecContent object that contains the
         * contents of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The
         * content is formatted as JSON or YAML stored as a RawString.
         */
        var revisionType: RevisionLocationType?
        /**
         * Information about the location of a revision stored in Amazon S3.
         */
        var s3Location: S3Location?
        /**
         * Information about the location of an AWS Lambda deployment revision stored as a
         * RawString.
         */
        var string: RawString?

        fun build(): RevisionLocation
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AppSpecContent] inside the given [block]
         */
        fun appSpecContent(block: AppSpecContent.DslBuilder.() -> kotlin.Unit) {
            this.appSpecContent = AppSpecContent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.GitHubLocation] inside the given [block]
         */
        fun gitHubLocation(block: GitHubLocation.DslBuilder.() -> kotlin.Unit) {
            this.gitHubLocation = GitHubLocation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.S3Location] inside the given [block]
         */
        fun s3Location(block: S3Location.DslBuilder.() -> kotlin.Unit) {
            this.s3Location = S3Location.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RawString] inside the given [block]
         */
        fun string(block: RawString.DslBuilder.() -> kotlin.Unit) {
            this.string = RawString.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var appSpecContent: AppSpecContent? = null
        override var gitHubLocation: GitHubLocation? = null
        override var revisionType: RevisionLocationType? = null
        override var s3Location: S3Location? = null
        override var string: RawString? = null

        constructor(x: RevisionLocation) : this() {
            this.appSpecContent = x.appSpecContent
            this.gitHubLocation = x.gitHubLocation
            this.revisionType = x.revisionType
            this.s3Location = x.s3Location
            this.string = x.string
        }

        override fun build(): RevisionLocation = RevisionLocation(this)
        override fun appSpecContent(appSpecContent: AppSpecContent): FluentBuilder = apply { this.appSpecContent = appSpecContent }
        override fun gitHubLocation(gitHubLocation: GitHubLocation): FluentBuilder = apply { this.gitHubLocation = gitHubLocation }
        override fun revisionType(revisionType: RevisionLocationType): FluentBuilder = apply { this.revisionType = revisionType }
        override fun s3Location(s3Location: S3Location): FluentBuilder = apply { this.s3Location = s3Location }
        override fun string(string: RawString): FluentBuilder = apply { this.string = string }
    }
}
