// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a deployment rollback.
 */
class RollbackInfo private constructor(builder: BuilderImpl) {
    /**
     * The ID of the deployment rollback.
     */
    val rollbackDeploymentId: String? = builder.rollbackDeploymentId
    /**
     * Information that describes the status of a deployment rollback (for example, whether
     * the deployment can't be rolled back, is in progress, failed, or succeeded).
     */
    val rollbackMessage: String? = builder.rollbackMessage
    /**
     * The deployment ID of the deployment that was underway and triggered a rollback
     * deployment because it failed or was stopped.
     */
    val rollbackTriggeringDeploymentId: String? = builder.rollbackTriggeringDeploymentId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RollbackInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RollbackInfo(")
        append("rollbackDeploymentId=$rollbackDeploymentId,")
        append("rollbackMessage=$rollbackMessage,")
        append("rollbackTriggeringDeploymentId=$rollbackTriggeringDeploymentId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = rollbackDeploymentId?.hashCode() ?: 0
        result = 31 * result + (rollbackMessage?.hashCode() ?: 0)
        result = 31 * result + (rollbackTriggeringDeploymentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RollbackInfo

        if (rollbackDeploymentId != other.rollbackDeploymentId) return false
        if (rollbackMessage != other.rollbackMessage) return false
        if (rollbackTriggeringDeploymentId != other.rollbackTriggeringDeploymentId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RollbackInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RollbackInfo
        /**
         * The ID of the deployment rollback.
         */
        fun rollbackDeploymentId(rollbackDeploymentId: String): FluentBuilder
        /**
         * Information that describes the status of a deployment rollback (for example, whether
         * the deployment can't be rolled back, is in progress, failed, or succeeded).
         */
        fun rollbackMessage(rollbackMessage: String): FluentBuilder
        /**
         * The deployment ID of the deployment that was underway and triggered a rollback
         * deployment because it failed or was stopped.
         */
        fun rollbackTriggeringDeploymentId(rollbackTriggeringDeploymentId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the deployment rollback.
         */
        var rollbackDeploymentId: String?
        /**
         * Information that describes the status of a deployment rollback (for example, whether
         * the deployment can't be rolled back, is in progress, failed, or succeeded).
         */
        var rollbackMessage: String?
        /**
         * The deployment ID of the deployment that was underway and triggered a rollback
         * deployment because it failed or was stopped.
         */
        var rollbackTriggeringDeploymentId: String?

        fun build(): RollbackInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var rollbackDeploymentId: String? = null
        override var rollbackMessage: String? = null
        override var rollbackTriggeringDeploymentId: String? = null

        constructor(x: RollbackInfo) : this() {
            this.rollbackDeploymentId = x.rollbackDeploymentId
            this.rollbackMessage = x.rollbackMessage
            this.rollbackTriggeringDeploymentId = x.rollbackTriggeringDeploymentId
        }

        override fun build(): RollbackInfo = RollbackInfo(this)
        override fun rollbackDeploymentId(rollbackDeploymentId: String): FluentBuilder = apply { this.rollbackDeploymentId = rollbackDeploymentId }
        override fun rollbackMessage(rollbackMessage: String): FluentBuilder = apply { this.rollbackMessage = rollbackMessage }
        override fun rollbackTriggeringDeploymentId(rollbackTriggeringDeploymentId: String): FluentBuilder = apply { this.rollbackTriggeringDeploymentId = rollbackTriggeringDeploymentId }
    }
}
