// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the location of application artifacts stored in Amazon S3.
 */
class S3Location private constructor(builder: BuilderImpl) {
    /**
     * The name of the Amazon S3 bucket where the application revision is stored.
     */
    val bucket: String? = builder.bucket
    /**
     * The file type of the application revision. Must be one of the following:
     * tar: A tar archive file.
     * tgz: A compressed tar archive file.
     * zip: A zip archive file.
     */
    val bundleType: BundleType? = builder.bundleType
    /**
     * The ETag of the Amazon S3 object that represents the bundled artifacts for the
     * application revision.
     * If the ETag is not specified as an input parameter, ETag validation of the object is
     * skipped.
     */
    val eTag: String? = builder.eTag
    /**
     * The name of the Amazon S3 object that represents the bundled artifacts for the
     * application revision.
     */
    val key: String? = builder.key
    /**
     * A specific version of the Amazon S3 object that represents the bundled artifacts for
     * the application revision.
     * If the version is not specified, the system uses the most recent version by
     * default.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3Location = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucket=$bucket,")
        append("bundleType=$bundleType,")
        append("eTag=$eTag,")
        append("key=$key,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (bundleType?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3Location

        if (bucket != other.bucket) return false
        if (bundleType != other.bundleType) return false
        if (eTag != other.eTag) return false
        if (key != other.key) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3Location = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3Location
        /**
         * The name of the Amazon S3 bucket where the application revision is stored.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * The file type of the application revision. Must be one of the following:
         * tar: A tar archive file.
         * tgz: A compressed tar archive file.
         * zip: A zip archive file.
         */
        fun bundleType(bundleType: BundleType): FluentBuilder
        /**
         * The ETag of the Amazon S3 object that represents the bundled artifacts for the
         * application revision.
         * If the ETag is not specified as an input parameter, ETag validation of the object is
         * skipped.
         */
        fun eTag(eTag: String): FluentBuilder
        /**
         * The name of the Amazon S3 object that represents the bundled artifacts for the
         * application revision.
         */
        fun key(key: String): FluentBuilder
        /**
         * A specific version of the Amazon S3 object that represents the bundled artifacts for
         * the application revision.
         * If the version is not specified, the system uses the most recent version by
         * default.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the Amazon S3 bucket where the application revision is stored.
         */
        var bucket: String?
        /**
         * The file type of the application revision. Must be one of the following:
         * tar: A tar archive file.
         * tgz: A compressed tar archive file.
         * zip: A zip archive file.
         */
        var bundleType: BundleType?
        /**
         * The ETag of the Amazon S3 object that represents the bundled artifacts for the
         * application revision.
         * If the ETag is not specified as an input parameter, ETag validation of the object is
         * skipped.
         */
        var eTag: String?
        /**
         * The name of the Amazon S3 object that represents the bundled artifacts for the
         * application revision.
         */
        var key: String?
        /**
         * A specific version of the Amazon S3 object that represents the bundled artifacts for
         * the application revision.
         * If the version is not specified, the system uses the most recent version by
         * default.
         */
        var version: String?

        fun build(): S3Location
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var bundleType: BundleType? = null
        override var eTag: String? = null
        override var key: String? = null
        override var version: String? = null

        constructor(x: S3Location) : this() {
            this.bucket = x.bucket
            this.bundleType = x.bundleType
            this.eTag = x.eTag
            this.key = x.key
            this.version = x.version
        }

        override fun build(): S3Location = S3Location(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun bundleType(bundleType: BundleType): FluentBuilder = apply { this.bundleType = bundleType }
        override fun eTag(eTag: String): FluentBuilder = apply { this.eTag = eTag }
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
