// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a target group in Elastic Load Balancing to use in a deployment.
 * Instances are registered as targets in a target group, and traffic is routed to the
 * target group.
 */
class TargetGroupInfo private constructor(builder: BuilderImpl) {
    /**
     * For blue/green deployments, the name of the target group that instances in the
     * original environment are deregistered from, and instances in the replacement environment
     * are registered with. For in-place deployments, the name of the target group that
     * instances are deregistered from, so they are not serving traffic during a deployment,
     * and then re-registered with after the deployment is complete.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetGroupInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGroupInfo(")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetGroupInfo

        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetGroupInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetGroupInfo
        /**
         * For blue/green deployments, the name of the target group that instances in the
         * original environment are deregistered from, and instances in the replacement environment
         * are registered with. For in-place deployments, the name of the target group that
         * instances are deregistered from, so they are not serving traffic during a deployment,
         * and then re-registered with after the deployment is complete.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * For blue/green deployments, the name of the target group that instances in the
         * original environment are deregistered from, and instances in the replacement environment
         * are registered with. For in-place deployments, the name of the target group that
         * instances are deregistered from, so they are not serving traffic during a deployment,
         * and then re-registered with after the deployment is complete.
         */
        var name: String?

        fun build(): TargetGroupInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null

        constructor(x: TargetGroupInfo) : this() {
            this.name = x.name
        }

        override fun build(): TargetGroupInfo = TargetGroupInfo(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
