// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about two target groups and how traffic is routed during an Amazon ECS
 * deployment. An optional test traffic route can be specified.
 */
class TargetGroupPairInfo private constructor(builder: BuilderImpl) {
    /**
     * The path used by a load balancer to route production traffic when an Amazon ECS
     * deployment is complete.
     */
    val prodTrafficRoute: TrafficRoute? = builder.prodTrafficRoute
    /**
     * One pair of target groups. One is associated with the original task set. The second
     * is associated with the task set that serves traffic after the deployment is complete.
     */
    val targetGroups: List<TargetGroupInfo>? = builder.targetGroups
    /**
     * An optional path used by a load balancer to route test traffic after an Amazon ECS
     * deployment. Validation can occur while test traffic is served during a deployment.
     */
    val testTrafficRoute: TrafficRoute? = builder.testTrafficRoute

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetGroupPairInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGroupPairInfo(")
        append("prodTrafficRoute=$prodTrafficRoute,")
        append("targetGroups=$targetGroups,")
        append("testTrafficRoute=$testTrafficRoute)")
    }

    override fun hashCode(): kotlin.Int {
        var result = prodTrafficRoute?.hashCode() ?: 0
        result = 31 * result + (targetGroups?.hashCode() ?: 0)
        result = 31 * result + (testTrafficRoute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetGroupPairInfo

        if (prodTrafficRoute != other.prodTrafficRoute) return false
        if (targetGroups != other.targetGroups) return false
        if (testTrafficRoute != other.testTrafficRoute) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetGroupPairInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetGroupPairInfo
        /**
         * The path used by a load balancer to route production traffic when an Amazon ECS
         * deployment is complete.
         */
        fun prodTrafficRoute(prodTrafficRoute: TrafficRoute): FluentBuilder
        /**
         * One pair of target groups. One is associated with the original task set. The second
         * is associated with the task set that serves traffic after the deployment is complete.
         */
        fun targetGroups(targetGroups: List<TargetGroupInfo>): FluentBuilder
        /**
         * An optional path used by a load balancer to route test traffic after an Amazon ECS
         * deployment. Validation can occur while test traffic is served during a deployment.
         */
        fun testTrafficRoute(testTrafficRoute: TrafficRoute): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The path used by a load balancer to route production traffic when an Amazon ECS
         * deployment is complete.
         */
        var prodTrafficRoute: TrafficRoute?
        /**
         * One pair of target groups. One is associated with the original task set. The second
         * is associated with the task set that serves traffic after the deployment is complete.
         */
        var targetGroups: List<TargetGroupInfo>?
        /**
         * An optional path used by a load balancer to route test traffic after an Amazon ECS
         * deployment. Validation can occur while test traffic is served during a deployment.
         */
        var testTrafficRoute: TrafficRoute?

        fun build(): TargetGroupPairInfo
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoute] inside the given [block]
         */
        fun prodTrafficRoute(block: TrafficRoute.DslBuilder.() -> kotlin.Unit) {
            this.prodTrafficRoute = TrafficRoute.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoute] inside the given [block]
         */
        fun testTrafficRoute(block: TrafficRoute.DslBuilder.() -> kotlin.Unit) {
            this.testTrafficRoute = TrafficRoute.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var prodTrafficRoute: TrafficRoute? = null
        override var targetGroups: List<TargetGroupInfo>? = null
        override var testTrafficRoute: TrafficRoute? = null

        constructor(x: TargetGroupPairInfo) : this() {
            this.prodTrafficRoute = x.prodTrafficRoute
            this.targetGroups = x.targetGroups
            this.testTrafficRoute = x.testTrafficRoute
        }

        override fun build(): TargetGroupPairInfo = TargetGroupPairInfo(this)
        override fun prodTrafficRoute(prodTrafficRoute: TrafficRoute): FluentBuilder = apply { this.prodTrafficRoute = prodTrafficRoute }
        override fun targetGroups(targetGroups: List<TargetGroupInfo>): FluentBuilder = apply { this.targetGroups = targetGroups }
        override fun testTrafficRoute(testTrafficRoute: TrafficRoute): FluentBuilder = apply { this.testTrafficRoute = testTrafficRoute }
    }
}
