// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the instances to be used in the replacement environment in a
 * blue/green deployment.
 */
class TargetInstances private constructor(builder: BuilderImpl) {
    /**
     * The names of one or more Auto Scaling groups to identify a replacement environment for
     * a blue/green deployment.
     */
    val autoScalingGroups: List<String>? = builder.autoScalingGroups
    /**
     * Information about the groups of EC2 instance tags that an instance must be identified
     * by in order for it to be included in the replacement environment for a blue/green
     * deployment. Cannot be used in the same call as tagFilters.
     */
    val ec2TagSet: Ec2TagSet? = builder.ec2TagSet
    /**
     * The tag filter key, type, and value used to identify Amazon EC2 instances in a
     * replacement environment for a blue/green deployment. Cannot be used in the same call as
     * ec2TagSet.
     */
    val tagFilters: List<Ec2TagFilter>? = builder.tagFilters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetInstances = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetInstances(")
        append("autoScalingGroups=$autoScalingGroups,")
        append("ec2TagSet=$ec2TagSet,")
        append("tagFilters=$tagFilters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroups?.hashCode() ?: 0
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (tagFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetInstances

        if (autoScalingGroups != other.autoScalingGroups) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (tagFilters != other.tagFilters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetInstances = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetInstances
        /**
         * The names of one or more Auto Scaling groups to identify a replacement environment for
         * a blue/green deployment.
         */
        fun autoScalingGroups(autoScalingGroups: List<String>): FluentBuilder
        /**
         * Information about the groups of EC2 instance tags that an instance must be identified
         * by in order for it to be included in the replacement environment for a blue/green
         * deployment. Cannot be used in the same call as tagFilters.
         */
        fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder
        /**
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a
         * replacement environment for a blue/green deployment. Cannot be used in the same call as
         * ec2TagSet.
         */
        fun tagFilters(tagFilters: List<Ec2TagFilter>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The names of one or more Auto Scaling groups to identify a replacement environment for
         * a blue/green deployment.
         */
        var autoScalingGroups: List<String>?
        /**
         * Information about the groups of EC2 instance tags that an instance must be identified
         * by in order for it to be included in the replacement environment for a blue/green
         * deployment. Cannot be used in the same call as tagFilters.
         */
        var ec2TagSet: Ec2TagSet?
        /**
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a
         * replacement environment for a blue/green deployment. Cannot be used in the same call as
         * ec2TagSet.
         */
        var tagFilters: List<Ec2TagFilter>?

        fun build(): TargetInstances
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        fun ec2TagSet(block: Ec2TagSet.DslBuilder.() -> kotlin.Unit) {
            this.ec2TagSet = Ec2TagSet.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoScalingGroups: List<String>? = null
        override var ec2TagSet: Ec2TagSet? = null
        override var tagFilters: List<Ec2TagFilter>? = null

        constructor(x: TargetInstances) : this() {
            this.autoScalingGroups = x.autoScalingGroups
            this.ec2TagSet = x.ec2TagSet
            this.tagFilters = x.tagFilters
        }

        override fun build(): TargetInstances = TargetInstances(this)
        override fun autoScalingGroups(autoScalingGroups: List<String>): FluentBuilder = apply { this.autoScalingGroups = autoScalingGroups }
        override fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder = apply { this.ec2TagSet = ec2TagSet }
        override fun tagFilters(tagFilters: List<Ec2TagFilter>): FluentBuilder = apply { this.tagFilters = tagFilters }
    }
}
