// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * A configuration that shifts traffic from one version of a Lambda function or ECS task
 * set to another in two increments. The original and target Lambda function versions or
 * ECS task sets are specified in the deployment's AppSpec file.
 */
class TimeBasedCanary private constructor(builder: BuilderImpl) {
    /**
     * The number of minutes between the first and second traffic shifts of a
     * TimeBasedCanary deployment.
     */
    val canaryInterval: Int = builder.canaryInterval
    /**
     * The percentage of traffic to shift in the first increment of a
     * TimeBasedCanary deployment.
     */
    val canaryPercentage: Int = builder.canaryPercentage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TimeBasedCanary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TimeBasedCanary(")
        append("canaryInterval=$canaryInterval,")
        append("canaryPercentage=$canaryPercentage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = canaryInterval
        result = 31 * result + (canaryPercentage)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TimeBasedCanary

        if (canaryInterval != other.canaryInterval) return false
        if (canaryPercentage != other.canaryPercentage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TimeBasedCanary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TimeBasedCanary
        /**
         * The number of minutes between the first and second traffic shifts of a
         * TimeBasedCanary deployment.
         */
        fun canaryInterval(canaryInterval: Int): FluentBuilder
        /**
         * The percentage of traffic to shift in the first increment of a
         * TimeBasedCanary deployment.
         */
        fun canaryPercentage(canaryPercentage: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of minutes between the first and second traffic shifts of a
         * TimeBasedCanary deployment.
         */
        var canaryInterval: Int
        /**
         * The percentage of traffic to shift in the first increment of a
         * TimeBasedCanary deployment.
         */
        var canaryPercentage: Int

        fun build(): TimeBasedCanary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var canaryInterval: Int = 0
        override var canaryPercentage: Int = 0

        constructor(x: TimeBasedCanary) : this() {
            this.canaryInterval = x.canaryInterval
            this.canaryPercentage = x.canaryPercentage
        }

        override fun build(): TimeBasedCanary = TimeBasedCanary(this)
        override fun canaryInterval(canaryInterval: Int): FluentBuilder = apply { this.canaryInterval = canaryInterval }
        override fun canaryPercentage(canaryPercentage: Int): FluentBuilder = apply { this.canaryPercentage = canaryPercentage }
    }
}
