// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * A configuration that shifts traffic from one version of a Lambda function or ECS task
 * set to another in equal increments, with an equal number of minutes between each
 * increment. The original and target Lambda function versions or ECS task sets are
 * specified in the deployment's AppSpec file.
 */
class TimeBasedLinear private constructor(builder: BuilderImpl) {
    /**
     * The number of minutes between each incremental traffic shift of a
     * TimeBasedLinear deployment.
     */
    val linearInterval: Int = builder.linearInterval
    /**
     * The percentage of traffic that is shifted at the start of each increment of a
     * TimeBasedLinear deployment.
     */
    val linearPercentage: Int = builder.linearPercentage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TimeBasedLinear = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TimeBasedLinear(")
        append("linearInterval=$linearInterval,")
        append("linearPercentage=$linearPercentage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = linearInterval
        result = 31 * result + (linearPercentage)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TimeBasedLinear

        if (linearInterval != other.linearInterval) return false
        if (linearPercentage != other.linearPercentage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TimeBasedLinear = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TimeBasedLinear
        /**
         * The number of minutes between each incremental traffic shift of a
         * TimeBasedLinear deployment.
         */
        fun linearInterval(linearInterval: Int): FluentBuilder
        /**
         * The percentage of traffic that is shifted at the start of each increment of a
         * TimeBasedLinear deployment.
         */
        fun linearPercentage(linearPercentage: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of minutes between each incremental traffic shift of a
         * TimeBasedLinear deployment.
         */
        var linearInterval: Int
        /**
         * The percentage of traffic that is shifted at the start of each increment of a
         * TimeBasedLinear deployment.
         */
        var linearPercentage: Int

        fun build(): TimeBasedLinear
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var linearInterval: Int = 0
        override var linearPercentage: Int = 0

        constructor(x: TimeBasedLinear) : this() {
            this.linearInterval = x.linearInterval
            this.linearPercentage = x.linearPercentage
        }

        override fun build(): TimeBasedLinear = TimeBasedLinear(this)
        override fun linearInterval(linearInterval: Int): FluentBuilder = apply { this.linearInterval = linearInterval }
        override fun linearPercentage(linearPercentage: Int): FluentBuilder = apply { this.linearPercentage = linearPercentage }
    }
}
