// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * The configuration that specifies how traffic is shifted from one version of a Lambda
 * function to another version during an AWS Lambda deployment, or from one Amazon ECS task
 * set to another during an Amazon ECS deployment.
 */
class TrafficRoutingConfig private constructor(builder: BuilderImpl) {
    /**
     * A configuration that shifts traffic from one version of a Lambda function or ECS task
     * set to another in two increments. The original and target Lambda function versions or
     * ECS task sets are specified in the deployment's AppSpec file.
     */
    val timeBasedCanary: TimeBasedCanary? = builder.timeBasedCanary
    /**
     * A configuration that shifts traffic from one version of a Lambda function or ECS task
     * set to another in equal increments, with an equal number of minutes between each
     * increment. The original and target Lambda function versions or ECS task sets are
     * specified in the deployment's AppSpec file.
     */
    val timeBasedLinear: TimeBasedLinear? = builder.timeBasedLinear
    /**
     * The type of traffic shifting (TimeBasedCanary or
     * TimeBasedLinear) used by a deployment configuration.
     */
    val type: TrafficRoutingType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TrafficRoutingConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficRoutingConfig(")
        append("timeBasedCanary=$timeBasedCanary,")
        append("timeBasedLinear=$timeBasedLinear,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeBasedCanary?.hashCode() ?: 0
        result = 31 * result + (timeBasedLinear?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TrafficRoutingConfig

        if (timeBasedCanary != other.timeBasedCanary) return false
        if (timeBasedLinear != other.timeBasedLinear) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TrafficRoutingConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TrafficRoutingConfig
        /**
         * A configuration that shifts traffic from one version of a Lambda function or ECS task
         * set to another in two increments. The original and target Lambda function versions or
         * ECS task sets are specified in the deployment's AppSpec file.
         */
        fun timeBasedCanary(timeBasedCanary: TimeBasedCanary): FluentBuilder
        /**
         * A configuration that shifts traffic from one version of a Lambda function or ECS task
         * set to another in equal increments, with an equal number of minutes between each
         * increment. The original and target Lambda function versions or ECS task sets are
         * specified in the deployment's AppSpec file.
         */
        fun timeBasedLinear(timeBasedLinear: TimeBasedLinear): FluentBuilder
        /**
         * The type of traffic shifting (TimeBasedCanary or
         * TimeBasedLinear) used by a deployment configuration.
         */
        fun type(type: TrafficRoutingType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A configuration that shifts traffic from one version of a Lambda function or ECS task
         * set to another in two increments. The original and target Lambda function versions or
         * ECS task sets are specified in the deployment's AppSpec file.
         */
        var timeBasedCanary: TimeBasedCanary?
        /**
         * A configuration that shifts traffic from one version of a Lambda function or ECS task
         * set to another in equal increments, with an equal number of minutes between each
         * increment. The original and target Lambda function versions or ECS task sets are
         * specified in the deployment's AppSpec file.
         */
        var timeBasedLinear: TimeBasedLinear?
        /**
         * The type of traffic shifting (TimeBasedCanary or
         * TimeBasedLinear) used by a deployment configuration.
         */
        var type: TrafficRoutingType?

        fun build(): TrafficRoutingConfig
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TimeBasedCanary] inside the given [block]
         */
        fun timeBasedCanary(block: TimeBasedCanary.DslBuilder.() -> kotlin.Unit) {
            this.timeBasedCanary = TimeBasedCanary.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TimeBasedLinear] inside the given [block]
         */
        fun timeBasedLinear(block: TimeBasedLinear.DslBuilder.() -> kotlin.Unit) {
            this.timeBasedLinear = TimeBasedLinear.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var timeBasedCanary: TimeBasedCanary? = null
        override var timeBasedLinear: TimeBasedLinear? = null
        override var type: TrafficRoutingType? = null

        constructor(x: TrafficRoutingConfig) : this() {
            this.timeBasedCanary = x.timeBasedCanary
            this.timeBasedLinear = x.timeBasedLinear
            this.type = x.type
        }

        override fun build(): TrafficRoutingConfig = TrafficRoutingConfig(this)
        override fun timeBasedCanary(timeBasedCanary: TimeBasedCanary): FluentBuilder = apply { this.timeBasedCanary = timeBasedCanary }
        override fun timeBasedLinear(timeBasedLinear: TimeBasedLinear): FluentBuilder = apply { this.timeBasedLinear = timeBasedLinear }
        override fun type(type: TrafficRoutingType): FluentBuilder = apply { this.type = type }
    }
}
