// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of an UpdateDeploymentGroup operation.
 */
class UpdateDeploymentGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * Information to add or change about Amazon CloudWatch alarms when the deployment group
     * is updated.
     */
    val alarmConfiguration: AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The application name that corresponds to the deployment group to update.
     */
    val applicationName: String? = builder.applicationName
    /**
     * Information for an automatic rollback configuration that is added or changed when a
     * deployment group is updated.
     */
    val autoRollbackConfiguration: AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * The replacement list of Auto Scaling groups to be included in the deployment group, if
     * you want to change them. To keep the Auto Scaling groups, enter their names. To remove
     * Auto Scaling groups, do not enter any Auto Scaling group names.
     */
    val autoScalingGroups: List<String>? = builder.autoScalingGroups
    /**
     * Information about blue/green deployment options for a deployment group.
     */
    val blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * The current name of the deployment group.
     */
    val currentDeploymentGroupName: String? = builder.currentDeploymentGroupName
    /**
     * The replacement deployment configuration name to use, if you want to change it.
     */
    val deploymentConfigName: String? = builder.deploymentConfigName
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to
     * run and whether to route deployment traffic behind a load balancer.
     */
    val deploymentStyle: DeploymentStyle? = builder.deploymentStyle
    /**
     * The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
     * To keep the existing tags, enter their names. To remove tags, do not enter any tag
     * names.
     */
    val ec2TagFilters: List<Ec2TagFilter>? = builder.ec2TagFilters
    /**
     * Information about groups of tags applied to on-premises instances. The deployment
     * group includes only EC2 instances identified by all the tag groups.
     */
    val ec2TagSet: Ec2TagSet? = builder.ec2TagSet
    /**
     * The target Amazon ECS services in the deployment group. This applies only to
     * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
     * is specified as an Amazon ECS cluster and service name pair using the format
     * <clustername>:<servicename>.
     */
    val ecsServices: List<EcsService>? = builder.ecsServices
    /**
     * Information about the load balancer used in a deployment.
     */
    val loadBalancerInfo: LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * The new name of the deployment group, if you want to change it.
     */
    val newDeploymentGroupName: String? = builder.newDeploymentGroupName
    /**
     * The replacement set of on-premises instance tags on which to filter, if you want to
     * change them. To keep the existing tags, enter their names. To remove tags, do not enter
     * any tag names.
     */
    val onPremisesInstanceTagFilters: List<TagFilter>? = builder.onPremisesInstanceTagFilters
    /**
     * Information about an on-premises instance tag set. The deployment group includes only
     * on-premises instances identified by all the tag groups.
     */
    val onPremisesTagSet: OnPremisesTagSet? = builder.onPremisesTagSet
    /**
     * Indicates what happens when new EC2 instances are launched mid-deployment and do not
     * receive the deployed application revision.
     * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
     * one or more 'auto-update outdated instances' deployments to apply the deployed
     * application revision to the new EC2 instances.
     * If this option is set to IGNORE, CodeDeploy does not initiate a
     * deployment to update the new EC2 instances. This may result in instances having
     * different revisions.
     */
    val outdatedInstancesStrategy: OutdatedInstancesStrategy? = builder.outdatedInstancesStrategy
    /**
     * A replacement ARN for the service role, if you want to change it.
     */
    val serviceRoleArn: String? = builder.serviceRoleArn
    /**
     * Information about triggers to change when the deployment group is updated. For
     * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
     * CodeDeploy Deployment Group in the AWS CodeDeploy User
     * Guide.
     */
    val triggerConfigurations: List<TriggerConfig>? = builder.triggerConfigurations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateDeploymentGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDeploymentGroupRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("autoScalingGroups=$autoScalingGroups,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("currentDeploymentGroupName=$currentDeploymentGroupName,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentStyle=$deploymentStyle,")
        append("ec2TagFilters=$ec2TagFilters,")
        append("ec2TagSet=$ec2TagSet,")
        append("ecsServices=$ecsServices,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("newDeploymentGroupName=$newDeploymentGroupName,")
        append("onPremisesInstanceTagFilters=$onPremisesInstanceTagFilters,")
        append("onPremisesTagSet=$onPremisesTagSet,")
        append("outdatedInstancesStrategy=$outdatedInstancesStrategy,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("triggerConfigurations=$triggerConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroups?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (currentDeploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (ec2TagFilters?.hashCode() ?: 0)
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (ecsServices?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (newDeploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (onPremisesInstanceTagFilters?.hashCode() ?: 0)
        result = 31 * result + (onPremisesTagSet?.hashCode() ?: 0)
        result = 31 * result + (outdatedInstancesStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (triggerConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateDeploymentGroupRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (autoScalingGroups != other.autoScalingGroups) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (currentDeploymentGroupName != other.currentDeploymentGroupName) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (ec2TagFilters != other.ec2TagFilters) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (ecsServices != other.ecsServices) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (newDeploymentGroupName != other.newDeploymentGroupName) return false
        if (onPremisesInstanceTagFilters != other.onPremisesInstanceTagFilters) return false
        if (onPremisesTagSet != other.onPremisesTagSet) return false
        if (outdatedInstancesStrategy != other.outdatedInstancesStrategy) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (triggerConfigurations != other.triggerConfigurations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateDeploymentGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateDeploymentGroupRequest
        /**
         * Information to add or change about Amazon CloudWatch alarms when the deployment group
         * is updated.
         */
        fun alarmConfiguration(alarmConfiguration: AlarmConfiguration): FluentBuilder
        /**
         * The application name that corresponds to the deployment group to update.
         */
        fun applicationName(applicationName: String): FluentBuilder
        /**
         * Information for an automatic rollback configuration that is added or changed when a
         * deployment group is updated.
         */
        fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder
        /**
         * The replacement list of Auto Scaling groups to be included in the deployment group, if
         * you want to change them. To keep the Auto Scaling groups, enter their names. To remove
         * Auto Scaling groups, do not enter any Auto Scaling group names.
         */
        fun autoScalingGroups(autoScalingGroups: List<String>): FluentBuilder
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder
        /**
         * The current name of the deployment group.
         */
        fun currentDeploymentGroupName(currentDeploymentGroupName: String): FluentBuilder
        /**
         * The replacement deployment configuration name to use, if you want to change it.
         */
        fun deploymentConfigName(deploymentConfigName: String): FluentBuilder
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder
        /**
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
         * To keep the existing tags, enter their names. To remove tags, do not enter any tag
         * names.
         */
        fun ec2TagFilters(ec2TagFilters: List<Ec2TagFilter>): FluentBuilder
        /**
         * Information about groups of tags applied to on-premises instances. The deployment
         * group includes only EC2 instances identified by all the tag groups.
         */
        fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        fun ecsServices(ecsServices: List<EcsService>): FluentBuilder
        /**
         * Information about the load balancer used in a deployment.
         */
        fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder
        /**
         * The new name of the deployment group, if you want to change it.
         */
        fun newDeploymentGroupName(newDeploymentGroupName: String): FluentBuilder
        /**
         * The replacement set of on-premises instance tags on which to filter, if you want to
         * change them. To keep the existing tags, enter their names. To remove tags, do not enter
         * any tag names.
         */
        fun onPremisesInstanceTagFilters(onPremisesInstanceTagFilters: List<TagFilter>): FluentBuilder
        /**
         * Information about an on-premises instance tag set. The deployment group includes only
         * on-premises instances identified by all the tag groups.
         */
        fun onPremisesTagSet(onPremisesTagSet: OnPremisesTagSet): FluentBuilder
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        fun outdatedInstancesStrategy(outdatedInstancesStrategy: OutdatedInstancesStrategy): FluentBuilder
        /**
         * A replacement ARN for the service role, if you want to change it.
         */
        fun serviceRoleArn(serviceRoleArn: String): FluentBuilder
        /**
         * Information about triggers to change when the deployment group is updated. For
         * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
         * CodeDeploy Deployment Group in the AWS CodeDeploy User
         * Guide.
         */
        fun triggerConfigurations(triggerConfigurations: List<TriggerConfig>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information to add or change about Amazon CloudWatch alarms when the deployment group
         * is updated.
         */
        var alarmConfiguration: AlarmConfiguration?
        /**
         * The application name that corresponds to the deployment group to update.
         */
        var applicationName: String?
        /**
         * Information for an automatic rollback configuration that is added or changed when a
         * deployment group is updated.
         */
        var autoRollbackConfiguration: AutoRollbackConfiguration?
        /**
         * The replacement list of Auto Scaling groups to be included in the deployment group, if
         * you want to change them. To keep the Auto Scaling groups, enter their names. To remove
         * Auto Scaling groups, do not enter any Auto Scaling group names.
         */
        var autoScalingGroups: List<String>?
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration?
        /**
         * The current name of the deployment group.
         */
        var currentDeploymentGroupName: String?
        /**
         * The replacement deployment configuration name to use, if you want to change it.
         */
        var deploymentConfigName: String?
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to
         * run and whether to route deployment traffic behind a load balancer.
         */
        var deploymentStyle: DeploymentStyle?
        /**
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them.
         * To keep the existing tags, enter their names. To remove tags, do not enter any tag
         * names.
         */
        var ec2TagFilters: List<Ec2TagFilter>?
        /**
         * Information about groups of tags applied to on-premises instances. The deployment
         * group includes only EC2 instances identified by all the tag groups.
         */
        var ec2TagSet: Ec2TagSet?
        /**
         * The target Amazon ECS services in the deployment group. This applies only to
         * deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service
         * is specified as an Amazon ECS cluster and service name pair using the format
         * <clustername>:<servicename>.
         */
        var ecsServices: List<EcsService>?
        /**
         * Information about the load balancer used in a deployment.
         */
        var loadBalancerInfo: LoadBalancerInfo?
        /**
         * The new name of the deployment group, if you want to change it.
         */
        var newDeploymentGroupName: String?
        /**
         * The replacement set of on-premises instance tags on which to filter, if you want to
         * change them. To keep the existing tags, enter their names. To remove tags, do not enter
         * any tag names.
         */
        var onPremisesInstanceTagFilters: List<TagFilter>?
        /**
         * Information about an on-premises instance tag set. The deployment group includes only
         * on-premises instances identified by all the tag groups.
         */
        var onPremisesTagSet: OnPremisesTagSet?
        /**
         * Indicates what happens when new EC2 instances are launched mid-deployment and do not
         * receive the deployed application revision.
         * If this option is set to UPDATE or is unspecified, CodeDeploy initiates
         * one or more 'auto-update outdated instances' deployments to apply the deployed
         * application revision to the new EC2 instances.
         * If this option is set to IGNORE, CodeDeploy does not initiate a
         * deployment to update the new EC2 instances. This may result in instances having
         * different revisions.
         */
        var outdatedInstancesStrategy: OutdatedInstancesStrategy?
        /**
         * A replacement ARN for the service role, if you want to change it.
         */
        var serviceRoleArn: String?
        /**
         * Information about triggers to change when the deployment group is updated. For
         * examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
         * CodeDeploy Deployment Group in the AWS CodeDeploy User
         * Guide.
         */
        var triggerConfigurations: List<TriggerConfig>?

        fun build(): UpdateDeploymentGroupRequest
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        fun alarmConfiguration(block: AlarmConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.alarmConfiguration = AlarmConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        fun autoRollbackConfiguration(block: AutoRollbackConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = AutoRollbackConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        fun blueGreenDeploymentConfiguration(block: BlueGreenDeploymentConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = BlueGreenDeploymentConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        fun deploymentStyle(block: DeploymentStyle.DslBuilder.() -> kotlin.Unit) {
            this.deploymentStyle = DeploymentStyle.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        fun ec2TagSet(block: Ec2TagSet.DslBuilder.() -> kotlin.Unit) {
            this.ec2TagSet = Ec2TagSet.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        fun loadBalancerInfo(block: LoadBalancerInfo.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancerInfo = LoadBalancerInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet] inside the given [block]
         */
        fun onPremisesTagSet(block: OnPremisesTagSet.DslBuilder.() -> kotlin.Unit) {
            this.onPremisesTagSet = OnPremisesTagSet.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarmConfiguration: AlarmConfiguration? = null
        override var applicationName: String? = null
        override var autoRollbackConfiguration: AutoRollbackConfiguration? = null
        override var autoScalingGroups: List<String>? = null
        override var blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration? = null
        override var currentDeploymentGroupName: String? = null
        override var deploymentConfigName: String? = null
        override var deploymentStyle: DeploymentStyle? = null
        override var ec2TagFilters: List<Ec2TagFilter>? = null
        override var ec2TagSet: Ec2TagSet? = null
        override var ecsServices: List<EcsService>? = null
        override var loadBalancerInfo: LoadBalancerInfo? = null
        override var newDeploymentGroupName: String? = null
        override var onPremisesInstanceTagFilters: List<TagFilter>? = null
        override var onPremisesTagSet: OnPremisesTagSet? = null
        override var outdatedInstancesStrategy: OutdatedInstancesStrategy? = null
        override var serviceRoleArn: String? = null
        override var triggerConfigurations: List<TriggerConfig>? = null

        constructor(x: UpdateDeploymentGroupRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.autoScalingGroups = x.autoScalingGroups
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.currentDeploymentGroupName = x.currentDeploymentGroupName
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentStyle = x.deploymentStyle
            this.ec2TagFilters = x.ec2TagFilters
            this.ec2TagSet = x.ec2TagSet
            this.ecsServices = x.ecsServices
            this.loadBalancerInfo = x.loadBalancerInfo
            this.newDeploymentGroupName = x.newDeploymentGroupName
            this.onPremisesInstanceTagFilters = x.onPremisesInstanceTagFilters
            this.onPremisesTagSet = x.onPremisesTagSet
            this.outdatedInstancesStrategy = x.outdatedInstancesStrategy
            this.serviceRoleArn = x.serviceRoleArn
            this.triggerConfigurations = x.triggerConfigurations
        }

        override fun build(): UpdateDeploymentGroupRequest = UpdateDeploymentGroupRequest(this)
        override fun alarmConfiguration(alarmConfiguration: AlarmConfiguration): FluentBuilder = apply { this.alarmConfiguration = alarmConfiguration }
        override fun applicationName(applicationName: String): FluentBuilder = apply { this.applicationName = applicationName }
        override fun autoRollbackConfiguration(autoRollbackConfiguration: AutoRollbackConfiguration): FluentBuilder = apply { this.autoRollbackConfiguration = autoRollbackConfiguration }
        override fun autoScalingGroups(autoScalingGroups: List<String>): FluentBuilder = apply { this.autoScalingGroups = autoScalingGroups }
        override fun blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration: BlueGreenDeploymentConfiguration): FluentBuilder = apply { this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration }
        override fun currentDeploymentGroupName(currentDeploymentGroupName: String): FluentBuilder = apply { this.currentDeploymentGroupName = currentDeploymentGroupName }
        override fun deploymentConfigName(deploymentConfigName: String): FluentBuilder = apply { this.deploymentConfigName = deploymentConfigName }
        override fun deploymentStyle(deploymentStyle: DeploymentStyle): FluentBuilder = apply { this.deploymentStyle = deploymentStyle }
        override fun ec2TagFilters(ec2TagFilters: List<Ec2TagFilter>): FluentBuilder = apply { this.ec2TagFilters = ec2TagFilters }
        override fun ec2TagSet(ec2TagSet: Ec2TagSet): FluentBuilder = apply { this.ec2TagSet = ec2TagSet }
        override fun ecsServices(ecsServices: List<EcsService>): FluentBuilder = apply { this.ecsServices = ecsServices }
        override fun loadBalancerInfo(loadBalancerInfo: LoadBalancerInfo): FluentBuilder = apply { this.loadBalancerInfo = loadBalancerInfo }
        override fun newDeploymentGroupName(newDeploymentGroupName: String): FluentBuilder = apply { this.newDeploymentGroupName = newDeploymentGroupName }
        override fun onPremisesInstanceTagFilters(onPremisesInstanceTagFilters: List<TagFilter>): FluentBuilder = apply { this.onPremisesInstanceTagFilters = onPremisesInstanceTagFilters }
        override fun onPremisesTagSet(onPremisesTagSet: OnPremisesTagSet): FluentBuilder = apply { this.onPremisesTagSet = onPremisesTagSet }
        override fun outdatedInstancesStrategy(outdatedInstancesStrategy: OutdatedInstancesStrategy): FluentBuilder = apply { this.outdatedInstancesStrategy = outdatedInstancesStrategy }
        override fun serviceRoleArn(serviceRoleArn: String): FluentBuilder = apply { this.serviceRoleArn = serviceRoleArn }
        override fun triggerConfigurations(triggerConfigurations: List<TriggerConfig>): FluentBuilder = apply { this.triggerConfigurations = triggerConfigurations }
    }
}
