// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.BatchGetApplicationRevisionsResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.RevisionInfo
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetApplicationRevisionsOperationDeserializer: HttpDeserialize<BatchGetApplicationRevisionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetApplicationRevisionsResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetApplicationRevisionsError(context, response)
        }
        val builder = BatchGetApplicationRevisionsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetApplicationRevisionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeBatchGetApplicationRevisionsOperationBody(builder: BatchGetApplicationRevisionsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationName"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val REVISIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("revisions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONNAME_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(REVISIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONNAME_DESCRIPTOR.index -> builder.applicationName = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                REVISIONS_DESCRIPTOR.index -> builder.revisions =
                    deserializer.deserializeList(REVISIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RevisionInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRevisionInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwBatchGetApplicationRevisionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer()
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer()
        "BatchLimitExceededException" -> BatchLimitExceededExceptionDeserializer()
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer()
        "InvalidRevisionException" -> InvalidRevisionExceptionDeserializer()
        "RevisionRequiredException" -> RevisionRequiredExceptionDeserializer()
        else -> throw CodeDeployException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
