// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListDeploymentInstancesOperationDeserializer: HttpDeserialize<ListDeploymentInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDeploymentInstancesResponse {
        if (!response.status.isSuccess()) {
            throwListDeploymentInstancesError(context, response)
        }
        val builder = ListDeploymentInstancesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDeploymentInstancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListDeploymentInstancesOperationBody(builder: ListDeploymentInstancesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCESLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("instancesList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCESLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCESLIST_DESCRIPTOR.index -> builder.instancesList =
                    deserializer.deserializeList(INSTANCESLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListDeploymentInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer()
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer()
        "DeploymentNotStartedException" -> DeploymentNotStartedExceptionDeserializer()
        "InvalidComputePlatformException" -> InvalidComputePlatformExceptionDeserializer()
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer()
        "InvalidDeploymentInstanceTypeException" -> InvalidDeploymentInstanceTypeExceptionDeserializer()
        "InvalidInstanceStatusException" -> InvalidInstanceStatusExceptionDeserializer()
        "InvalidInstanceTypeException" -> InvalidInstanceTypeExceptionDeserializer()
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer()
        "InvalidTargetFilterNameException" -> InvalidTargetFilterNameExceptionDeserializer()
        else -> throw CodeDeployException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
