// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.RegisterApplicationRevisionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class RegisterApplicationRevisionOperationDeserializer: HttpDeserialize<RegisterApplicationRevisionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterApplicationRevisionResponse {
        if (!response.status.isSuccess()) {
            throwRegisterApplicationRevisionError(context, response)
        }
        val builder = RegisterApplicationRevisionResponse.builder()

        return builder.build()
    }
}

private suspend fun throwRegisterApplicationRevisionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer()
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer()
        "DescriptionTooLongException" -> DescriptionTooLongExceptionDeserializer()
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer()
        "InvalidRevisionException" -> InvalidRevisionExceptionDeserializer()
        "RevisionRequiredException" -> RevisionRequiredExceptionDeserializer()
        else -> throw CodeDeployException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
