// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDeploymentGroupOperationDeserializer: HttpDeserialize<UpdateDeploymentGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDeploymentGroupResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentGroupError(context, response)
        }
        val builder = UpdateDeploymentGroupResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDeploymentGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeUpdateDeploymentGroupOperationBody(builder: UpdateDeploymentGroupResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOOKSNOTCLEANEDUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hooksNotCleanedUp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOOKSNOTCLEANEDUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOOKSNOTCLEANEDUP_DESCRIPTOR.index -> builder.hooksNotCleanedUp =
                    deserializer.deserializeList(HOOKSNOTCLEANEDUP_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoScalingGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoScalingGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateDeploymentGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AlarmsLimitExceededException" -> AlarmsLimitExceededExceptionDeserializer()
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer()
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer()
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer()
        "DeploymentGroupAlreadyExistsException" -> DeploymentGroupAlreadyExistsExceptionDeserializer()
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer()
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer()
        "ECSServiceMappingLimitExceededException" -> EcsServiceMappingLimitExceededExceptionDeserializer()
        "InvalidAlarmConfigException" -> InvalidAlarmConfigExceptionDeserializer()
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer()
        "InvalidAutoRollbackConfigException" -> InvalidAutoRollbackConfigExceptionDeserializer()
        "InvalidAutoScalingGroupException" -> InvalidAutoScalingGroupExceptionDeserializer()
        "InvalidBlueGreenDeploymentConfigurationException" -> InvalidBlueGreenDeploymentConfigurationExceptionDeserializer()
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer()
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer()
        "InvalidDeploymentStyleException" -> InvalidDeploymentStyleExceptionDeserializer()
        "InvalidEC2TagCombinationException" -> InvalidEc2TagCombinationExceptionDeserializer()
        "InvalidEC2TagException" -> InvalidEc2TagExceptionDeserializer()
        "InvalidECSServiceException" -> InvalidEcsServiceExceptionDeserializer()
        "InvalidInputException" -> InvalidInputExceptionDeserializer()
        "InvalidLoadBalancerInfoException" -> InvalidLoadBalancerInfoExceptionDeserializer()
        "InvalidOnPremisesTagCombinationException" -> InvalidOnPremisesTagCombinationExceptionDeserializer()
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer()
        "InvalidTagException" -> InvalidTagExceptionDeserializer()
        "InvalidTargetGroupPairException" -> InvalidTargetGroupPairExceptionDeserializer()
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer()
        "InvalidTriggerConfigException" -> InvalidTriggerConfigExceptionDeserializer()
        "LifecycleHookLimitExceededException" -> LifecycleHookLimitExceededExceptionDeserializer()
        "TagSetListLimitExceededException" -> TagSetListLimitExceededExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "TriggerTargetsLimitExceededException" -> TriggerTargetsLimitExceededExceptionDeserializer()
        else -> throw CodeDeployException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
