// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The response of `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html) that specifies if an agent profiles or not and for how long to return profiling data.
 */
class AgentConfiguration private constructor(builder: Builder) {
    /**
     * Parameters used by the profiler. The valid parameters are:
     * + `MaxStackDepth` - The maximum depth of the stacks in the code that is represented in the profile. For example, if CodeGuru Profiler finds a method `A`, which calls method `B`, which calls method `C`, which calls method `D`, then the depth is 4. If the `maxDepth` is set to 2, then the profiler evaluates `A` and `B`.
     * + `MemoryUsageLimitPercent` - The percentage of memory that is used by the profiler.
     * + `MinimumTimeForReportingInMilliseconds` - The minimum time in milliseconds between sending reports.
     * + `ReportingIntervalInMilliseconds` - The reporting interval in milliseconds used to report profiles.
     * + `SamplingIntervalInMilliseconds` - The sampling interval in milliseconds that is used to profile samples.
     */
    val agentParameters: Map<String, String>? = builder.agentParameters
    /**
     * How long a profiling agent should send profiling data using `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html). For example, if this is set to 300, the profiling agent calls `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html) every 5 minutes to submit the profiled data collected during that period.
     */
    val periodInSeconds: kotlin.Int? = builder.periodInSeconds
    /**
     * A `Boolean` that specifies whether the profiling agent collects profiling data or not. Set to `true` to enable profiling.
     */
    val shouldProfile: kotlin.Boolean? = builder.shouldProfile

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.AgentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentConfiguration(")
        append("agentParameters=$agentParameters,")
        append("periodInSeconds=$periodInSeconds,")
        append("shouldProfile=$shouldProfile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentParameters?.hashCode() ?: 0
        result = 31 * result + (periodInSeconds ?: 0)
        result = 31 * result + (shouldProfile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentConfiguration

        if (agentParameters != other.agentParameters) return false
        if (periodInSeconds != other.periodInSeconds) return false
        if (shouldProfile != other.shouldProfile) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.AgentConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Parameters used by the profiler. The valid parameters are:
         * + `MaxStackDepth` - The maximum depth of the stacks in the code that is represented in the profile. For example, if CodeGuru Profiler finds a method `A`, which calls method `B`, which calls method `C`, which calls method `D`, then the depth is 4. If the `maxDepth` is set to 2, then the profiler evaluates `A` and `B`.
         * + `MemoryUsageLimitPercent` - The percentage of memory that is used by the profiler.
         * + `MinimumTimeForReportingInMilliseconds` - The minimum time in milliseconds between sending reports.
         * + `ReportingIntervalInMilliseconds` - The reporting interval in milliseconds used to report profiles.
         * + `SamplingIntervalInMilliseconds` - The sampling interval in milliseconds that is used to profile samples.
         */
        var agentParameters: Map<String, String>? = null
        /**
         * How long a profiling agent should send profiling data using `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html). For example, if this is set to 300, the profiling agent calls `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html) every 5 minutes to submit the profiled data collected during that period.
         */
        var periodInSeconds: kotlin.Int? = null
        /**
         * A `Boolean` that specifies whether the profiling agent collects profiling data or not. Set to `true` to enable profiling.
         */
        var shouldProfile: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.AgentConfiguration) : this() {
            this.agentParameters = x.agentParameters
            this.periodInSeconds = x.periodInSeconds
            this.shouldProfile = x.shouldProfile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.AgentConfiguration = AgentConfiguration(this)
    }
}
