// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * Details about an anomaly in a specific metric of application profile. The anomaly is detected using analysis of the metric data over a period of time.
 */
class Anomaly private constructor(builder: Builder) {
    /**
     * A list of the instances of the detected anomalies during the requested period.
     */
    val instances: List<AnomalyInstance>? = builder.instances
    /**
     * Details about the metric that the analysis used when it detected the anomaly. The metric includes the name of the frame that was analyzed with the type and thread states used to derive the metric value for that frame.
     */
    val metric: aws.sdk.kotlin.services.codeguruprofiler.model.Metric? = builder.metric
    /**
     * The reason for which metric was flagged as anomalous.
     */
    val reason: kotlin.String? = builder.reason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.Anomaly = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Anomaly(")
        append("instances=$instances,")
        append("metric=$metric,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instances?.hashCode() ?: 0
        result = 31 * result + (metric?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Anomaly

        if (instances != other.instances) return false
        if (metric != other.metric) return false
        if (reason != other.reason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.Anomaly = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of the instances of the detected anomalies during the requested period.
         */
        var instances: List<AnomalyInstance>? = null
        /**
         * Details about the metric that the analysis used when it detected the anomaly. The metric includes the name of the frame that was analyzed with the type and thread states used to derive the metric value for that frame.
         */
        var metric: aws.sdk.kotlin.services.codeguruprofiler.model.Metric? = null
        /**
         * The reason for which metric was flagged as anomalous.
         */
        var reason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.Anomaly) : this() {
            this.instances = x.instances
            this.metric = x.metric
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.Anomaly = Anomaly(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.Metric] inside the given [block]
         */
        fun metric(block: aws.sdk.kotlin.services.codeguruprofiler.model.Metric.Builder.() -> kotlin.Unit) {
            this.metric = aws.sdk.kotlin.services.codeguruprofiler.model.Metric.invoke(block)
        }
    }
}
