// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * Details about the metric that the analysis used when it detected the anomaly. The metric what is analyzed to create recommendations. It includes the name of the frame that was analyzed and the type and thread states used to derive the metric value for that frame.
 */
class Metric private constructor(builder: Builder) {
    /**
     * The name of the method that appears as a frame in any stack in a profile.
     */
    val frameName: kotlin.String? = builder.frameName
    /**
     * The list of application runtime thread states that is used to calculate the metric value for the frame.
     */
    val threadStates: List<String>? = builder.threadStates
    /**
     * A type that specifies how a metric for a frame is analyzed. The supported value `AggregatedRelativeTotalTime` is an aggregation of the metric value for one frame that is calculated across the occurences of all frames in a profile.
     */
    val type: aws.sdk.kotlin.services.codeguruprofiler.model.MetricType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.Metric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Metric(")
        append("frameName=$frameName,")
        append("threadStates=$threadStates,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frameName?.hashCode() ?: 0
        result = 31 * result + (threadStates?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Metric

        if (frameName != other.frameName) return false
        if (threadStates != other.threadStates) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.Metric = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the method that appears as a frame in any stack in a profile.
         */
        var frameName: kotlin.String? = null
        /**
         * The list of application runtime thread states that is used to calculate the metric value for the frame.
         */
        var threadStates: List<String>? = null
        /**
         * A type that specifies how a metric for a frame is analyzed. The supported value `AggregatedRelativeTotalTime` is an aggregation of the metric value for one frame that is calculated across the occurences of all frames in a profile.
         */
        var type: aws.sdk.kotlin.services.codeguruprofiler.model.MetricType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.Metric) : this() {
            this.frameName = x.frameName
            this.threadStates = x.threadStates
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.Metric = Metric(this)
    }
}
