// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Profiling status includes information about the last time a profile agent pinged back, the last time a profile was received, and the aggregation period and start time for the most recent aggregated profile.
 */
class ProfilingStatus private constructor(builder: Builder) {
    /**
     * The date and time when the profiling agent most recently pinged back. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val latestAgentOrchestratedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.latestAgentOrchestratedAt
    /**
     * The date and time when the most recent profile was received. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val latestAgentProfileReportedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.latestAgentProfileReportedAt
    /**
     * An `AggregatedProfileTime`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html) object that contains the aggregation period and start time for an aggregated profile.
     */
    val latestAggregatedProfile: aws.sdk.kotlin.services.codeguruprofiler.model.AggregatedProfileTime? = builder.latestAggregatedProfile

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProfilingStatus(")
        append("latestAgentOrchestratedAt=$latestAgentOrchestratedAt,")
        append("latestAgentProfileReportedAt=$latestAgentProfileReportedAt,")
        append("latestAggregatedProfile=$latestAggregatedProfile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = latestAgentOrchestratedAt?.hashCode() ?: 0
        result = 31 * result + (latestAgentProfileReportedAt?.hashCode() ?: 0)
        result = 31 * result + (latestAggregatedProfile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProfilingStatus

        if (latestAgentOrchestratedAt != other.latestAgentOrchestratedAt) return false
        if (latestAgentProfileReportedAt != other.latestAgentProfileReportedAt) return false
        if (latestAggregatedProfile != other.latestAggregatedProfile) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time when the profiling agent most recently pinged back. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var latestAgentOrchestratedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the most recent profile was received. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var latestAgentProfileReportedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An `AggregatedProfileTime`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html) object that contains the aggregation period and start time for an aggregated profile.
         */
        var latestAggregatedProfile: aws.sdk.kotlin.services.codeguruprofiler.model.AggregatedProfileTime? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus) : this() {
            this.latestAgentOrchestratedAt = x.latestAgentOrchestratedAt
            this.latestAgentProfileReportedAt = x.latestAgentProfileReportedAt
            this.latestAggregatedProfile = x.latestAggregatedProfile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus = ProfilingStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.AggregatedProfileTime] inside the given [block]
         */
        fun latestAggregatedProfile(block: aws.sdk.kotlin.services.codeguruprofiler.model.AggregatedProfileTime.Builder.() -> kotlin.Unit) {
            this.latestAggregatedProfile = aws.sdk.kotlin.services.codeguruprofiler.model.AggregatedProfileTime.invoke(block)
        }
    }
}
