// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.FrameMetric
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class BatchGetFrameMetricDataOperationSerializer: HttpSerialize<BatchGetFrameMetricDataRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchGetFrameMetricDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "profilingGroups",
                "${input.profilingGroupName}".encodeLabel(),
                "frames",
                "-",
                "metrics",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.endTime != null) append("endTime", input.endTime.format(TimestampFormat.ISO_8601))
                if (input.period != null) append("period", input.period)
                if (input.startTime != null) append("startTime", input.startTime.format(TimestampFormat.ISO_8601))
                if (input.targetResolution != null) append("targetResolution", input.targetResolution.value)
            }
        }

        val payload = serializeBatchGetFrameMetricDataOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchGetFrameMetricDataOperationBody(context: ExecutionContext, input: BatchGetFrameMetricDataRequest): ByteArray {
    val serializer = JsonSerializer()
    val FRAMEMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("frameMetrics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FRAMEMETRICS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.frameMetrics != null) {
            listField(FRAMEMETRICS_DESCRIPTOR) {
                for (el0 in input.frameMetrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFrameMetricDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
