// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class PostAgentProfileOperationSerializer: HttpSerialize<PostAgentProfileRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PostAgentProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "profilingGroups",
                "${input.profilingGroupName}".encodeLabel(),
                "agentProfile",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                append("profileToken", (input.profileToken ?: context.idempotencyTokenProvider.generateToken()))
            }
        }

        builder.headers {
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
        }

        if (input.agentProfile != null) {
            builder.body = ByteArrayContent(input.agentProfile)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.agentProfile == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
