// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the BatchGetFrameMetricDataResponse.
 */
public class BatchGetFrameMetricDataResponse private constructor(builder: Builder) {
    /**
     * The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * List of instances, or time steps, in the time series. For example, if the `period` is one day (`PT24H)`), and the `resolution` is five minutes (`PT5M`), then there are 288 `endTimes` in the list that are each five minutes appart.
     */
    public val endTimes: List<TimestampStructure>? = builder.endTimes
    /**
     * Details of the metrics to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame.
     */
    public val frameMetricData: List<FrameMetricDatum>? = builder.frameMetricData
    /**
     * Resolution or granularity of the profile data used to generate the time series. This is the value used to jump through time steps in a time series. There are 3 valid values.
     * + `P1D` — 1 day
     * + `PT1H` — 1 hour
     * + `PT5M` — 5 minutes
     */
    public val resolution: aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod? = builder.resolution
    /**
     * The start time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
     */
    public val unprocessedEndTimes: Map<String, List<TimestampStructure>>? = builder.unprocessedEndTimes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetFrameMetricDataResponse(")
        append("endTime=$endTime,")
        append("endTimes=$endTimes,")
        append("frameMetricData=$frameMetricData,")
        append("resolution=$resolution,")
        append("startTime=$startTime,")
        append("unprocessedEndTimes=$unprocessedEndTimes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (endTimes?.hashCode() ?: 0)
        result = 31 * result + (frameMetricData?.hashCode() ?: 0)
        result = 31 * result + (resolution?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (unprocessedEndTimes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetFrameMetricDataResponse

        if (endTime != other.endTime) return false
        if (endTimes != other.endTimes) return false
        if (frameMetricData != other.frameMetricData) return false
        if (resolution != other.resolution) return false
        if (startTime != other.startTime) return false
        if (unprocessedEndTimes != other.unprocessedEndTimes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of instances, or time steps, in the time series. For example, if the `period` is one day (`PT24H)`), and the `resolution` is five minutes (`PT5M`), then there are 288 `endTimes` in the list that are each five minutes appart.
         */
        public var endTimes: List<TimestampStructure>? = null
        /**
         * Details of the metrics to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame.
         */
        public var frameMetricData: List<FrameMetricDatum>? = null
        /**
         * Resolution or granularity of the profile data used to generate the time series. This is the value used to jump through time steps in a time series. There are 3 valid values.
         * + `P1D` — 1 day
         * + `PT1H` — 1 hour
         * + `PT5M` — 5 minutes
         */
        public var resolution: aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod? = null
        /**
         * The start time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
         */
        public var unprocessedEndTimes: Map<String, List<TimestampStructure>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse) : this() {
            this.endTime = x.endTime
            this.endTimes = x.endTimes
            this.frameMetricData = x.frameMetricData
            this.resolution = x.resolution
            this.startTime = x.startTime
            this.unprocessedEndTimes = x.unprocessedEndTimes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse = BatchGetFrameMetricDataResponse(this)
    }
}
