// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about potential recommendations that might be created from the analysis of profiling data.
 */
public class FindingsReportSummary private constructor(builder: Builder) {
    /**
     * The universally unique identifier (UUID) of the recommendation report.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val profileEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.profileEndTime
    /**
     * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val profileStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.profileStartTime
    /**
     * The name of the profiling group that is associated with the analysis data.
     */
    public val profilingGroupName: kotlin.String? = builder.profilingGroupName
    /**
     * The total number of different recommendations that were found by the analysis.
     */
    public val totalNumberOfFindings: kotlin.Int? = builder.totalNumberOfFindings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.FindingsReportSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingsReportSummary(")
        append("id=$id,")
        append("profileEndTime=$profileEndTime,")
        append("profileStartTime=$profileStartTime,")
        append("profilingGroupName=$profilingGroupName,")
        append("totalNumberOfFindings=$totalNumberOfFindings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (profileEndTime?.hashCode() ?: 0)
        result = 31 * result + (profileStartTime?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (totalNumberOfFindings ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingsReportSummary

        if (id != other.id) return false
        if (profileEndTime != other.profileEndTime) return false
        if (profileStartTime != other.profileStartTime) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (totalNumberOfFindings != other.totalNumberOfFindings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.FindingsReportSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The universally unique identifier (UUID) of the recommendation report.
         */
        public var id: kotlin.String? = null
        /**
         * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var profileEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var profileStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the profiling group that is associated with the analysis data.
         */
        public var profilingGroupName: kotlin.String? = null
        /**
         * The total number of different recommendations that were found by the analysis.
         */
        public var totalNumberOfFindings: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.FindingsReportSummary) : this() {
            this.id = x.id
            this.profileEndTime = x.profileEndTime
            this.profileStartTime = x.profileStartTime
            this.profilingGroupName = x.profilingGroupName
            this.totalNumberOfFindings = x.totalNumberOfFindings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.FindingsReportSummary = FindingsReportSummary(this)
    }
}
