// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codeguruprofiler.model.Anomaly
import aws.sdk.kotlin.services.codeguruprofiler.model.CodeGuruProfilerException
import aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.Recommendation
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetRecommendationsOperationDeserializer: HttpDeserialize<GetRecommendationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRecommendationsResponse {
        if (!response.status.isSuccess()) {
            throwGetRecommendationsError(context, response)
        }
        val builder = GetRecommendationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRecommendationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRecommendationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeGuruProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecommendationsOperationBody(builder: GetRecommendationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("anomalies"))
    val PROFILEENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("profileEndTime"))
    val PROFILESTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("profileStartTime"))
    val PROFILINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profilingGroupName"))
    val RECOMMENDATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("recommendations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALIES_DESCRIPTOR)
        field(PROFILEENDTIME_DESCRIPTOR)
        field(PROFILESTARTTIME_DESCRIPTOR)
        field(PROFILINGGROUPNAME_DESCRIPTOR)
        field(RECOMMENDATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALIES_DESCRIPTOR.index -> builder.anomalies =
                    deserializer.deserializeList(ANOMALIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Anomaly>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnomalyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROFILEENDTIME_DESCRIPTOR.index -> builder.profileEndTime = deserializeString().let { Instant.fromIso8601(it) }
                PROFILESTARTTIME_DESCRIPTOR.index -> builder.profileStartTime = deserializeString().let { Instant.fromIso8601(it) }
                PROFILINGGROUPNAME_DESCRIPTOR.index -> builder.profilingGroupName = deserializeString()
                RECOMMENDATIONS_DESCRIPTOR.index -> builder.recommendations =
                    deserializer.deserializeList(RECOMMENDATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Recommendation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRecommendationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
