// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.endpoints

import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region eu-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test34() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test35() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack enabled
    @Test
    fun test36() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack disabled
    @Test
    fun test37() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack enabled
    @Test
    fun test38() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack disabled
    @Test
    fun test39() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test40() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test41() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test42() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
