// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codeguruprofiler.model.*
import aws.sdk.kotlin.services.codeguruprofiler.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "CodeGuruProfiler"
const val ServiceApiVersion: String = "2019-07-18"
const val SdkVersion: String = "0.9.4-beta"

internal class DefaultCodeGuruProfilerClient(override val config: CodeGuruProfilerClient.Config) : CodeGuruProfilerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Add up to 2 anomaly notifications channels for a profiling group.
     */
    override suspend fun addNotificationChannels(input: AddNotificationChannelsRequest): AddNotificationChannelsResponse {
        val op = SdkHttpOperation.build<AddNotificationChannelsRequest, AddNotificationChannelsResponse> {
            serializer = AddNotificationChannelsOperationSerializer()
            deserializer = AddNotificationChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddNotificationChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the time series of values for a requested list
     * of frame metrics from a time period.
     */
    override suspend fun batchGetFrameMetricData(input: BatchGetFrameMetricDataRequest): BatchGetFrameMetricDataResponse {
        val op = SdkHttpOperation.build<BatchGetFrameMetricDataRequest, BatchGetFrameMetricDataResponse> {
            serializer = BatchGetFrameMetricDataOperationSerializer()
            deserializer = BatchGetFrameMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetFrameMetricData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Used by profiler agents to report their current state and to receive remote
     * configuration updates. For example, ConfigureAgent can be used
     * to tell an agent whether to profile or not and for how long to return profiling data.
     */
    override suspend fun configureAgent(input: ConfigureAgentRequest): ConfigureAgentResponse {
        val op = SdkHttpOperation.build<ConfigureAgentRequest, ConfigureAgentResponse> {
            serializer = ConfigureAgentOperationSerializer()
            deserializer = ConfigureAgentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfigureAgent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates a profiling group.
     */
    override suspend fun createProfilingGroup(input: CreateProfilingGroupRequest): CreateProfilingGroupResponse {
        val op = SdkHttpOperation.build<CreateProfilingGroupRequest, CreateProfilingGroupResponse> {
            serializer = CreateProfilingGroupOperationSerializer()
            deserializer = CreateProfilingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateProfilingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a profiling group.
     */
    override suspend fun deleteProfilingGroup(input: DeleteProfilingGroupRequest): DeleteProfilingGroupResponse {
        val op = SdkHttpOperation.build<DeleteProfilingGroupRequest, DeleteProfilingGroupResponse> {
            serializer = DeleteProfilingGroupOperationSerializer()
            deserializer = DeleteProfilingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteProfilingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * object that contains information about the requested profiling group.
     */
    override suspend fun describeProfilingGroup(input: DescribeProfilingGroupRequest): DescribeProfilingGroupResponse {
        val op = SdkHttpOperation.build<DescribeProfilingGroupRequest, DescribeProfilingGroupResponse> {
            serializer = DescribeProfilingGroupOperationSerializer()
            deserializer = DescribeProfilingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProfilingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * FindingsReportSummary
     * objects that contain analysis results for all profiling groups in your AWS account.
     */
    override suspend fun getFindingsReportAccountSummary(input: GetFindingsReportAccountSummaryRequest): GetFindingsReportAccountSummaryResponse {
        val op = SdkHttpOperation.build<GetFindingsReportAccountSummaryRequest, GetFindingsReportAccountSummaryResponse> {
            serializer = GetFindingsReportAccountSummaryOperationSerializer()
            deserializer = GetFindingsReportAccountSummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingsReportAccountSummary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Get the current configuration for anomaly notifications for a profiling group.
     */
    override suspend fun getNotificationConfiguration(input: GetNotificationConfigurationRequest): GetNotificationConfigurationResponse {
        val op = SdkHttpOperation.build<GetNotificationConfigurationRequest, GetNotificationConfigurationResponse> {
            serializer = GetNotificationConfigurationOperationSerializer()
            deserializer = GetNotificationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNotificationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the JSON-formatted resource-based policy on a profiling group.
     */
    override suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse {
        val op = SdkHttpOperation.build<GetPolicyRequest, GetPolicyResponse> {
            serializer = GetPolicyOperationSerializer()
            deserializer = GetPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Gets the aggregated profile of a profiling group for a specified time range.
     * Amazon CodeGuru Profiler collects posted agent profiles for a profiling group
     * into aggregated profiles.
     * Because aggregated profiles expire over time GetProfile is not idempotent.
     * Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: startTime,
     * endTime, period. The maximum time range allowed is 7 days. If you specify all 3 parameters,
     * an exception is thrown. If you specify only period, the latest aggregated profile is returned.
     * Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to
     * UTC. The aggregation period of an aggregated profile determines how long it is retained. For more
     * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
     * AggregatedProfileTime
     * . The aggregated profile's aggregation period determines how long
     * it is retained by CodeGuru Profiler.
     * If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
     * If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
     * If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
     * There are two use cases for calling GetProfile.
     * <ol>
     * If you want to return an aggregated profile that already exists, use
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html">
     * ListProfileTimes
     * to
     * view the time ranges of existing aggregated profiles. Use them in a GetProfile request to return a specific,
     * existing aggregated profile.
     * If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile,
     * then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time
     * range and return them as one aggregated profile.
     * If aggregated profiles do not exist for the full time range requested, then
     * aggregated profiles for a smaller time range are returned. For example, if the
     * requested time range is from 00:00 to 00:20, and the existing aggregated profiles are
     * from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
     * </ol>
     */
    override suspend fun getProfile(input: GetProfileRequest): GetProfileResponse {
        val op = SdkHttpOperation.build<GetProfileRequest, GetProfileResponse> {
            serializer = GetProfileOperationSerializer()
            deserializer = GetProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html">
     * Recommendation
     * objects that contain recommendations for a profiling group for a given time period. A list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html">
     * Anomaly
     * objects that contains details about anomalies detected in the profiling group for the same time period is also
     * returned.
     */
    override suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse {
        val op = SdkHttpOperation.build<GetRecommendationsRequest, GetRecommendationsResponse> {
            serializer = GetRecommendationsOperationSerializer()
            deserializer = GetRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * List the available reports for a given profiling group and time range.
     */
    override suspend fun listFindingsReports(input: ListFindingsReportsRequest): ListFindingsReportsResponse {
        val op = SdkHttpOperation.build<ListFindingsReportsRequest, ListFindingsReportsResponse> {
            serializer = ListFindingsReportsOperationSerializer()
            deserializer = ListFindingsReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindingsReports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists the start times of the available aggregated profiles of a profiling group
     * for an aggregation period within the specified time range.
     */
    override suspend fun listProfileTimes(input: ListProfileTimesRequest): ListProfileTimesResponse {
        val op = SdkHttpOperation.build<ListProfileTimesRequest, ListProfileTimesResponse> {
            serializer = ListProfileTimesOperationSerializer()
            deserializer = ListProfileTimesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProfileTimes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of profiling groups. The profiling groups are returned as
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * objects.
     */
    override suspend fun listProfilingGroups(input: ListProfilingGroupsRequest): ListProfilingGroupsResponse {
        val op = SdkHttpOperation.build<ListProfilingGroupsRequest, ListProfilingGroupsResponse> {
            serializer = ListProfilingGroupsOperationSerializer()
            deserializer = ListProfilingGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProfilingGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the tags that are assigned to a specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Submits profiling data to an aggregated profile of a profiling group. To get an
     * aggregated profile that is created with this profiling data, use
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html">
     * GetProfile
     * .
     */
    override suspend fun postAgentProfile(input: PostAgentProfileRequest): PostAgentProfileResponse {
        val op = SdkHttpOperation.build<PostAgentProfileRequest, PostAgentProfileResponse> {
            serializer = PostAgentProfileOperationSerializer()
            deserializer = PostAgentProfileOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "PostAgentProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Adds permissions to a profiling group's resource-based policy
     * that are provided using an action group. If a profiling group doesn't have
     * a resource-based policy, one is created for it using the permissions in the action group and
     * the roles and users in the principals parameter.
     * The one supported action group that can be added is agentPermission
     * which grants ConfigureAgent and PostAgent permissions. For
     * more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based
     * policies in CodeGuru Profiler in the Amazon CodeGuru Profiler User
     * Guide, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * PostAgentProfile
     * .
     * The first time you call PutPermission on a profiling group, do not specify a revisionId because
     * it doesn't have a resource-based policy. Subsequent calls must provide a revisionId to specify
     * which revision of the resource-based policy to add the permissions to.
     * The response contains the profiling group's JSON-formatted resource policy.
     */
    override suspend fun putPermission(input: PutPermissionRequest): PutPermissionResponse {
        val op = SdkHttpOperation.build<PutPermissionRequest, PutPermissionResponse> {
            serializer = PutPermissionOperationSerializer()
            deserializer = PutPermissionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutPermission"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Remove one anomaly notifications channel for a profiling group.
     */
    override suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse {
        val op = SdkHttpOperation.build<RemoveNotificationChannelRequest, RemoveNotificationChannelResponse> {
            serializer = RemoveNotificationChannelOperationSerializer()
            deserializer = RemoveNotificationChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveNotificationChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Removes permissions from a profiling group's resource-based policy that are provided
     * using an action group. The one supported action group that can be removed is
     * agentPermission which grants ConfigureAgent and
     * PostAgent permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler in the Amazon
     * CodeGuru Profiler User Guide, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * PostAgentProfile
     * .
     */
    override suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse {
        val op = SdkHttpOperation.build<RemovePermissionRequest, RemovePermissionResponse> {
            serializer = RemovePermissionOperationSerializer()
            deserializer = RemovePermissionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemovePermission"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is
     * useful or not.
     */
    override suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse {
        val op = SdkHttpOperation.build<SubmitFeedbackRequest, SubmitFeedbackResponse> {
            serializer = SubmitFeedbackOperationSerializer()
            deserializer = SubmitFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "SubmitFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Use to assign one or more tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Use to remove one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Updates a profiling group.
     */
    override suspend fun updateProfilingGroup(input: UpdateProfilingGroupRequest): UpdateProfilingGroupResponse {
        val op = SdkHttpOperation.build<UpdateProfilingGroupRequest, UpdateProfilingGroupResponse> {
            serializer = UpdateProfilingGroupOperationSerializer()
            deserializer = UpdateProfilingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProfilingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "codeguru-profiler"
        }
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
