// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the GetFindingsReportAccountSummaryRequest.
 */
class GetFindingsReportAccountSummaryRequest private constructor(builder: Builder) {
    /**
     * A Boolean value indicating whether to only return reports from daily profiles. If set
     * to True, only analysis data from daily profiles is returned. If set to False,
     * analysis data is returned from smaller time windows (for example, one hour).
     */
    val dailyReportsOnly: kotlin.Boolean? = builder.dailyReportsOnly
    /**
     * The maximum number of results returned by  GetFindingsReportAccountSummary in paginated output.
     * When this parameter is used, GetFindingsReportAccountSummary only returns maxResults
     * results in a single page along with a nextToken response element. The remaining results of the initial
     * request can be seen by sending another GetFindingsReportAccountSummary request with the returned
     * nextToken value.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The nextToken value returned from a previous paginated GetFindingsReportAccountSummary
     * request where maxResults was used and the results exceeded the value of that parameter.
     * Pagination continues from the end of the previous results that returned the nextToken value.
     * This token should be treated as an opaque identifier that is only used to retrieve
     * the next items in a list and not for other programmatic purposes.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetFindingsReportAccountSummaryRequest(")
        append("dailyReportsOnly=$dailyReportsOnly,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dailyReportsOnly?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetFindingsReportAccountSummaryRequest

        if (dailyReportsOnly != other.dailyReportsOnly) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A Boolean value indicating whether to only return reports from daily profiles. If set
         * to True, only analysis data from daily profiles is returned. If set to False,
         * analysis data is returned from smaller time windows (for example, one hour).
         */
        var dailyReportsOnly: kotlin.Boolean? = null
        /**
         * The maximum number of results returned by  GetFindingsReportAccountSummary in paginated output.
         * When this parameter is used, GetFindingsReportAccountSummary only returns maxResults
         * results in a single page along with a nextToken response element. The remaining results of the initial
         * request can be seen by sending another GetFindingsReportAccountSummary request with the returned
         * nextToken value.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The nextToken value returned from a previous paginated GetFindingsReportAccountSummary
         * request where maxResults was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest) : this() {
            this.dailyReportsOnly = x.dailyReportsOnly
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest = GetFindingsReportAccountSummaryRequest(this)
    }
}
