// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the getProfileRequest.
 */
class GetProfileRequest private constructor(builder: Builder) {
    /**
     * The format of the returned profiling data. The format maps to the
     * Accept and Content-Type headers of the
     * HTTP request. You can specify one of the following:
     * or the default .
     * application/json — standard JSON format
     * application/x-amzn-ion — the Amazon Ion data format. For more information,
     * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
     */
    val accept: kotlin.String? = builder.accept
    /**
     * The end time of the requested profile. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * If you specify endTime, then you must also specify period
     * or startTime, but not both.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The maximum depth of the stacks in the code that is represented in
     * the aggregated profile. For example, if CodeGuru Profiler finds a method A,
     * which calls method B, which calls method C, which
     * calls method D, then the depth is 4. If the maxDepth is
     * set to 2, then the aggregated profile contains representations of methods A
     * and B.
     */
    val maxDepth: kotlin.Int? = builder.maxDepth
    /**
     * Used with startTime or endTime to specify
     * the time range for the returned aggregated profile. Specify using
     * the ISO 8601 format. For example, P1DT1H1M1S.
     * To get the latest aggregated profile, specify only period.
     */
    val period: kotlin.String? = builder.period
    /**
     * The name of the profiling group to get.
     */
    val profilingGroupName: kotlin.String? = builder.profilingGroupName
    /**
     * The start time of the profile to get. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * If you specify startTime, then you must also specify period
     * or endTime, but not both.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetProfileRequest(")
        append("accept=$accept,")
        append("endTime=$endTime,")
        append("maxDepth=$maxDepth,")
        append("period=$period,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accept?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxDepth ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetProfileRequest

        if (accept != other.accept) return false
        if (endTime != other.endTime) return false
        if (maxDepth != other.maxDepth) return false
        if (period != other.period) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The format of the returned profiling data. The format maps to the
         * Accept and Content-Type headers of the
         * HTTP request. You can specify one of the following:
         * or the default .
         * application/json — standard JSON format
         * application/x-amzn-ion — the Amazon Ion data format. For more information,
         * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
         */
        var accept: kotlin.String? = null
        /**
         * The end time of the requested profile. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * If you specify endTime, then you must also specify period
         * or startTime, but not both.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum depth of the stacks in the code that is represented in
         * the aggregated profile. For example, if CodeGuru Profiler finds a method A,
         * which calls method B, which calls method C, which
         * calls method D, then the depth is 4. If the maxDepth is
         * set to 2, then the aggregated profile contains representations of methods A
         * and B.
         */
        var maxDepth: kotlin.Int? = null
        /**
         * Used with startTime or endTime to specify
         * the time range for the returned aggregated profile. Specify using
         * the ISO 8601 format. For example, P1DT1H1M1S.
         * To get the latest aggregated profile, specify only period.
         */
        var period: kotlin.String? = null
        /**
         * The name of the profiling group to get.
         */
        var profilingGroupName: kotlin.String? = null
        /**
         * The start time of the profile to get. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * If you specify startTime, then you must also specify period
         * or endTime, but not both.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileRequest) : this() {
            this.accept = x.accept
            this.endTime = x.endTime
            this.maxDepth = x.maxDepth
            this.period = x.period
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileRequest = GetProfileRequest(this)
    }
}
