// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * A set of rules used to make a recommendation during an analysis.
 */
class Pattern private constructor(builder: Builder) {
    /**
     * A list of the different counters used to determine if there is a match.
     */
    val countersToAggregate: List<String>? = builder.countersToAggregate
    /**
     * The description of the recommendation. This explains a potential
     * inefficiency in a profiled application.
     */
    val description: kotlin.String? = builder.description
    /**
     * The universally unique identifier (UUID) of this pattern.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name for this pattern.
     */
    val name: kotlin.String? = builder.name
    /**
     * A string that contains the steps recommended to address the potential inefficiency.
     */
    val resolutionSteps: kotlin.String? = builder.resolutionSteps
    /**
     * A list of frame names that were searched during the analysis that generated
     * a recommendation.
     */
    val targetFrames: List<List<String>>? = builder.targetFrames
    /**
     * The percentage of time an application spends in one method that triggers
     * a recommendation. The percentage of time is the same as the percentage of
     * the total gathered sample counts during analysis.
     */
    val thresholdPercent: kotlin.Double = builder.thresholdPercent

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.Pattern = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Pattern(")
        append("countersToAggregate=$countersToAggregate,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("resolutionSteps=$resolutionSteps,")
        append("targetFrames=$targetFrames,")
        append("thresholdPercent=$thresholdPercent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = countersToAggregate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resolutionSteps?.hashCode() ?: 0)
        result = 31 * result + (targetFrames?.hashCode() ?: 0)
        result = 31 * result + (thresholdPercent.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Pattern

        if (countersToAggregate != other.countersToAggregate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (resolutionSteps != other.resolutionSteps) return false
        if (targetFrames != other.targetFrames) return false
        if (thresholdPercent != other.thresholdPercent) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.Pattern = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of the different counters used to determine if there is a match.
         */
        var countersToAggregate: List<String>? = null
        /**
         * The description of the recommendation. This explains a potential
         * inefficiency in a profiled application.
         */
        var description: kotlin.String? = null
        /**
         * The universally unique identifier (UUID) of this pattern.
         */
        var id: kotlin.String? = null
        /**
         * The name for this pattern.
         */
        var name: kotlin.String? = null
        /**
         * A string that contains the steps recommended to address the potential inefficiency.
         */
        var resolutionSteps: kotlin.String? = null
        /**
         * A list of frame names that were searched during the analysis that generated
         * a recommendation.
         */
        var targetFrames: List<List<String>>? = null
        /**
         * The percentage of time an application spends in one method that triggers
         * a recommendation. The percentage of time is the same as the percentage of
         * the total gathered sample counts during analysis.
         */
        var thresholdPercent: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.Pattern) : this() {
            this.countersToAggregate = x.countersToAggregate
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.resolutionSteps = x.resolutionSteps
            this.targetFrames = x.targetFrames
            this.thresholdPercent = x.thresholdPercent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.Pattern = Pattern(this)
    }
}
