// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the postAgentProfileRequest.
 */
class PostAgentProfileRequest private constructor(builder: Builder) {
    /**
     * The submitted profiling data.
     */
    val agentProfile: kotlin.ByteArray? = builder.agentProfile
    /**
     * The format of the submitted profiling data. The format maps to the
     * Accept and Content-Type headers of the
     * HTTP request. You can specify one of the following:
     * or the default .
     * application/json — standard JSON format
     * application/x-amzn-ion — the Amazon Ion data format. For more information,
     * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
     * accidental submission of duplicate profiling data if there are failures and retries.
     */
    val profileToken: kotlin.String? = builder.profileToken
    /**
     * The name of the profiling group with the aggregated profile that receives the
     * submitted profiling data.
     */
    val profilingGroupName: kotlin.String? = builder.profilingGroupName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PostAgentProfileRequest(")
        append("agentProfile=$agentProfile,")
        append("contentType=$contentType,")
        append("profileToken=$profileToken,")
        append("profilingGroupName=$profilingGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentProfile?.contentHashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (profileToken?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PostAgentProfileRequest

        if (agentProfile != null) {
            if (other.agentProfile == null) return false
            if (!agentProfile.contentEquals(other.agentProfile)) return false
        } else if (other.agentProfile != null) return false
        if (contentType != other.contentType) return false
        if (profileToken != other.profileToken) return false
        if (profilingGroupName != other.profilingGroupName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The submitted profiling data.
         */
        var agentProfile: kotlin.ByteArray? = null
        /**
         * The format of the submitted profiling data. The format maps to the
         * Accept and Content-Type headers of the
         * HTTP request. You can specify one of the following:
         * or the default .
         * application/json — standard JSON format
         * application/x-amzn-ion — the Amazon Ion data format. For more information,
         * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
         */
        var contentType: kotlin.String? = null
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
         * accidental submission of duplicate profiling data if there are failures and retries.
         */
        var profileToken: kotlin.String? = null
        /**
         * The name of the profiling group with the aggregated profile that receives the
         * submitted profiling data.
         */
        var profilingGroupName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest) : this() {
            this.agentProfile = x.agentProfile
            this.contentType = x.contentType
            this.profileToken = x.profileToken
            this.profilingGroupName = x.profilingGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest = PostAgentProfileRequest(this)
    }
}
