// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.CodeGuruProfilerException
import aws.sdk.kotlin.services.codeguruprofiler.model.FrameMetricDatum
import aws.sdk.kotlin.services.codeguruprofiler.model.TimestampStructure
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class BatchGetFrameMetricDataOperationDeserializer: HttpDeserialize<BatchGetFrameMetricDataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetFrameMetricDataResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetFrameMetricDataError(context, response)
        }
        val builder = BatchGetFrameMetricDataResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetFrameMetricDataOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeBatchGetFrameMetricDataOperationBody(builder: BatchGetFrameMetricDataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ENDTIMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("endTimes"))
    val FRAMEMETRICDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("frameMetricData"))
    val RESOLUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resolution"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val UNPROCESSEDENDTIMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("unprocessedEndTimes"))
    val UNPROCESSEDENDTIMES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(ENDTIMES_DESCRIPTOR)
        field(FRAMEMETRICDATA_DESCRIPTOR)
        field(RESOLUTION_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(UNPROCESSEDENDTIMES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENDTIMES_DESCRIPTOR.index -> builder.endTimes =
                    deserializer.deserializeList(ENDTIMES_DESCRIPTOR) {
                        val col0 = mutableListOf<TimestampStructure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimestampStructureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FRAMEMETRICDATA_DESCRIPTOR.index -> builder.frameMetricData =
                    deserializer.deserializeList(FRAMEMETRICDATA_DESCRIPTOR) {
                        val col0 = mutableListOf<FrameMetricDatum>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFrameMetricDatumDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOLUTION_DESCRIPTOR.index -> builder.resolution = deserializeString().let { AggregationPeriod.fromValue(it) }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                UNPROCESSEDENDTIMES_DESCRIPTOR.index -> builder.unprocessedEndTimes =
                    deserializer.deserializeMap(UNPROCESSEDENDTIMES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<TimestampStructure>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(UNPROCESSEDENDTIMES_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<TimestampStructure>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeTimestampStructureDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwBatchGetFrameMetricDataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw CodeGuruProfilerException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
