// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Code artifacts are source code artifacts and build artifacts used in a repository analysis or a pull request review.
 * Source code artifacts are source code files in a Git repository that are
 * compressed into a .zip file.
 * Build artifacts are .jar or .class files that are compressed in a .zip file.
 */
class CodeArtifacts private constructor(builder: Builder) {
    /**
     * The S3 object key for a build artifacts .zip file that
     * contains .jar or .class files. This is required for a code review with security analysis. For more
     * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
     * analysis in the Amazon CodeGuru Reviewer User Guide.
     */
    val buildArtifactsObjectKey: kotlin.String? = builder.buildArtifactsObjectKey
    /**
     * The S3 object key for a source code .zip file. This is required for all code reviews.
     */
    val sourceCodeArtifactsObjectKey: kotlin.String? = builder.sourceCodeArtifactsObjectKey

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeArtifacts(")
        append("buildArtifactsObjectKey=$buildArtifactsObjectKey,")
        append("sourceCodeArtifactsObjectKey=$sourceCodeArtifactsObjectKey)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildArtifactsObjectKey?.hashCode() ?: 0
        result = 31 * result + (sourceCodeArtifactsObjectKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeArtifacts

        if (buildArtifactsObjectKey != other.buildArtifactsObjectKey) return false
        if (sourceCodeArtifactsObjectKey != other.sourceCodeArtifactsObjectKey) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts = Builder(this).apply(block).build()

    class Builder {
        /**
         * The S3 object key for a build artifacts .zip file that
         * contains .jar or .class files. This is required for a code review with security analysis. For more
         * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
         * analysis in the Amazon CodeGuru Reviewer User Guide.
         */
        var buildArtifactsObjectKey: kotlin.String? = null
        /**
         * The S3 object key for a source code .zip file. This is required for all code reviews.
         */
        var sourceCodeArtifactsObjectKey: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts) : this() {
            this.buildArtifactsObjectKey = x.buildArtifactsObjectKey
            this.sourceCodeArtifactsObjectKey = x.sourceCodeArtifactsObjectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts = CodeArtifacts(this)
    }
}
