// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
 * SourceCodeType
 * that
 * specifies the commit diff for a pull request on an associated repository. The SourceCommit
 * and DestinationCommit fields are required to do a pull request code review.
 */
class CommitDiffSourceCodeType private constructor(builder: Builder) {
    /**
     * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
     */
    val destinationCommit: kotlin.String? = builder.destinationCommit
    /**
     * The SHA of the merge base of a commit.
     */
    val mergeBaseCommit: kotlin.String? = builder.mergeBaseCommit
    /**
     * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
     */
    val sourceCommit: kotlin.String? = builder.sourceCommit

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommitDiffSourceCodeType(")
        append("destinationCommit=$destinationCommit,")
        append("mergeBaseCommit=$mergeBaseCommit,")
        append("sourceCommit=$sourceCommit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationCommit?.hashCode() ?: 0
        result = 31 * result + (mergeBaseCommit?.hashCode() ?: 0)
        result = 31 * result + (sourceCommit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommitDiffSourceCodeType

        if (destinationCommit != other.destinationCommit) return false
        if (mergeBaseCommit != other.mergeBaseCommit) return false
        if (sourceCommit != other.sourceCommit) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
         */
        var destinationCommit: kotlin.String? = null
        /**
         * The SHA of the merge base of a commit.
         */
        var mergeBaseCommit: kotlin.String? = null
        /**
         * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
         */
        var sourceCommit: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType) : this() {
            this.destinationCommit = x.destinationCommit
            this.mergeBaseCommit = x.mergeBaseCommit
            this.sourceCommit = x.sourceCommit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType = CommitDiffSourceCodeType(this)
    }
}
