// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



class ListRepositoryAssociationsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of repository association results returned by ListRepositoryAssociations
     * in paginated output. When this parameter is used, ListRepositoryAssociations only returns
     * maxResults results in a single page with a nextToken response
     * element. The remaining results of the initial request
     * can be seen by sending another ListRepositoryAssociations request with the returned
     * nextToken value.
     * This value can be between 1 and 100. If this parameter is not used, ListRepositoryAssociations
     * returns up to 100 results and a nextToken value if applicable.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * List of repository names to use as a filter.
     */
    val names: List<String>? = builder.names
    /**
     * The nextToken value returned from a previous paginated
     * ListRepositoryAssociations request where maxResults was used and the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous results
     * that returned the nextToken value.
     * Treat this token as an opaque identifier that is only used to retrieve
     * the next items in a list and not for other programmatic purposes.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * List of owners to use as a filter.
     * For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was
     * used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account
     * that was used to associate the repository.
     */
    val owners: List<String>? = builder.owners
    /**
     * List of provider types to use as a filter.
     */
    val providerTypes: List<ProviderType>? = builder.providerTypes
    /**
     * List of repository association states to use as a filter.
     * The valid repository association states are:
     * Associated: The repository
     * association is complete.
     * Associating: CodeGuru Reviewer is:
     * Setting up pull request notifications. This is required
     * for pull requests to trigger a CodeGuru Reviewer review.
     * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
     * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
     * reviews of code in your repository cannot be triggered.
     * Setting up source code access. This is required for CodeGuru Reviewer to securely
     * clone code in your repository.
     * Failed: The repository failed to associate or disassociate.
     * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
     * source code access.
     * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
     * with this repository if you want to review source code in it later. You can control access to code reviews created in an
     * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
     * associated repositories in the Amazon CodeGuru Reviewer User Guide.
     */
    val states: List<RepositoryAssociationState>? = builder.states

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRepositoryAssociationsRequest(")
        append("maxResults=$maxResults,")
        append("names=$names,")
        append("nextToken=$nextToken,")
        append("owners=$owners,")
        append("providerTypes=$providerTypes,")
        append("states=$states)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (names?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (owners?.hashCode() ?: 0)
        result = 31 * result + (providerTypes?.hashCode() ?: 0)
        result = 31 * result + (states?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRepositoryAssociationsRequest

        if (maxResults != other.maxResults) return false
        if (names != other.names) return false
        if (nextToken != other.nextToken) return false
        if (owners != other.owners) return false
        if (providerTypes != other.providerTypes) return false
        if (states != other.states) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of repository association results returned by ListRepositoryAssociations
         * in paginated output. When this parameter is used, ListRepositoryAssociations only returns
         * maxResults results in a single page with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListRepositoryAssociations request with the returned
         * nextToken value.
         * This value can be between 1 and 100. If this parameter is not used, ListRepositoryAssociations
         * returns up to 100 results and a nextToken value if applicable.
         */
        var maxResults: kotlin.Int? = null
        /**
         * List of repository names to use as a filter.
         */
        var names: List<String>? = null
        /**
         * The nextToken value returned from a previous paginated
         * ListRepositoryAssociations request where maxResults was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous results
         * that returned the nextToken value.
         * Treat this token as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        var nextToken: kotlin.String? = null
        /**
         * List of owners to use as a filter.
         * For Amazon Web Services CodeCommit, it is the name of the CodeCommit account that was
         * used to associate the repository. For other repository source providers, such as Bitbucket and GitHub Enterprise Server, this is name of the account
         * that was used to associate the repository.
         */
        var owners: List<String>? = null
        /**
         * List of provider types to use as a filter.
         */
        var providerTypes: List<ProviderType>? = null
        /**
         * List of repository association states to use as a filter.
         * The valid repository association states are:
         * Associated: The repository
         * association is complete.
         * Associating: CodeGuru Reviewer is:
         * Setting up pull request notifications. This is required
         * for pull requests to trigger a CodeGuru Reviewer review.
         * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
         * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
         * reviews of code in your repository cannot be triggered.
         * Setting up source code access. This is required for CodeGuru Reviewer to securely
         * clone code in your repository.
         * Failed: The repository failed to associate or disassociate.
         * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
         * source code access.
         * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
         * with this repository if you want to review source code in it later. You can control access to code reviews created in an
         * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
         * associated repositories in the Amazon CodeGuru Reviewer User Guide.
         */
        var states: List<RepositoryAssociationState>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsRequest) : this() {
            this.maxResults = x.maxResults
            this.names = x.names
            this.nextToken = x.nextToken
            this.owners = x.owners
            this.providerTypes = x.providerTypes
            this.states = x.states
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsRequest = ListRepositoryAssociationsRequest(this)
    }
}
