// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about recommendation feedback summaries.
 */
class RecommendationFeedbackSummary private constructor(builder: Builder) {
    /**
     * List for storing reactions. Reactions are utf-8 text code for emojis.
     */
    val reactions: List<Reaction>? = builder.reactions
    /**
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
     */
    val recommendationId: kotlin.String? = builder.recommendationId
    /**
     * The ID of the user that gave the feedback.
     * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
     * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
     */
    val userId: kotlin.String? = builder.userId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedbackSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationFeedbackSummary(")
        append("reactions=$reactions,")
        append("recommendationId=$recommendationId,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = reactions?.hashCode() ?: 0
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationFeedbackSummary

        if (reactions != other.reactions) return false
        if (recommendationId != other.recommendationId) return false
        if (userId != other.userId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedbackSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         */
        var reactions: List<Reaction>? = null
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        var recommendationId: kotlin.String? = null
        /**
         * The ID of the user that gave the feedback.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        var userId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedbackSummary) : this() {
            this.reactions = x.reactions
            this.recommendationId = x.recommendationId
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedbackSummary = RecommendationFeedbackSummary(this)
    }
}
