// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about an associated Amazon Web Services CodeCommit repository or an associated repository that is managed
 * by Amazon Web Services CodeStar Connections (for example, Bitbucket). This Repository object
 * is not used if your source code is in an associated GitHub repository.
 */
class Repository private constructor(builder: Builder) {
    /**
     * Information about a Bitbucket repository.
     */
    val bitbucket: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository? = builder.bitbucket
    /**
     * Information about an Amazon Web Services CodeCommit repository.
     */
    val codeCommit: aws.sdk.kotlin.services.codegurureviewer.model.CodeCommitRepository? = builder.codeCommit
    /**
     * Information about a GitHub Enterprise Server repository.
     */
    val gitHubEnterpriseServer: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository? = builder.gitHubEnterpriseServer
    /**
     * Information about a repository in an S3 bucket.
     */
    val s3Bucket: aws.sdk.kotlin.services.codegurureviewer.model.S3Repository? = builder.s3Bucket

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.Repository = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Repository(")
        append("bitbucket=$bitbucket,")
        append("codeCommit=$codeCommit,")
        append("gitHubEnterpriseServer=$gitHubEnterpriseServer,")
        append("s3Bucket=$s3Bucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitbucket?.hashCode() ?: 0
        result = 31 * result + (codeCommit?.hashCode() ?: 0)
        result = 31 * result + (gitHubEnterpriseServer?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Repository

        if (bitbucket != other.bitbucket) return false
        if (codeCommit != other.codeCommit) return false
        if (gitHubEnterpriseServer != other.gitHubEnterpriseServer) return false
        if (s3Bucket != other.s3Bucket) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.Repository = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about a Bitbucket repository.
         */
        var bitbucket: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository? = null
        /**
         * Information about an Amazon Web Services CodeCommit repository.
         */
        var codeCommit: aws.sdk.kotlin.services.codegurureviewer.model.CodeCommitRepository? = null
        /**
         * Information about a GitHub Enterprise Server repository.
         */
        var gitHubEnterpriseServer: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository? = null
        /**
         * Information about a repository in an S3 bucket.
         */
        var s3Bucket: aws.sdk.kotlin.services.codegurureviewer.model.S3Repository? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.Repository) : this() {
            this.bitbucket = x.bitbucket
            this.codeCommit = x.codeCommit
            this.gitHubEnterpriseServer = x.gitHubEnterpriseServer
            this.s3Bucket = x.s3Bucket
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.Repository = Repository(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository] inside the given [block]
         */
        fun bitbucket(block: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository.Builder.() -> kotlin.Unit) {
            this.bitbucket = aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CodeCommitRepository] inside the given [block]
         */
        fun codeCommit(block: aws.sdk.kotlin.services.codegurureviewer.model.CodeCommitRepository.Builder.() -> kotlin.Unit) {
            this.codeCommit = aws.sdk.kotlin.services.codegurureviewer.model.CodeCommitRepository.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository] inside the given [block]
         */
        fun gitHubEnterpriseServer(block: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository.Builder.() -> kotlin.Unit) {
            this.gitHubEnterpriseServer = aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3Repository] inside the given [block]
         */
        fun s3Bucket(block: aws.sdk.kotlin.services.codegurureviewer.model.S3Repository.Builder.() -> kotlin.Unit) {
            this.s3Bucket = aws.sdk.kotlin.services.codegurureviewer.model.S3Repository.invoke(block)
        }
    }
}
