// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a repository association. The
 * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html">
 * DescribeRepositoryAssociation
 * operation returns a RepositoryAssociation object.
 */
class RepositoryAssociation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) identifying the repository association.
     */
    val associationArn: kotlin.String? = builder.associationArn
    /**
     * The ID of the repository association.
     */
    val associationId: kotlin.String? = builder.associationId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
     * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
     * Connection
     * in
     * the Amazon Web Services CodeStar Connections API Reference.
     */
    val connectionArn: kotlin.String? = builder.connectionArn
    /**
     * The time, in milliseconds since the epoch, when the repository association was created.
     */
    val createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimeStamp
    /**
     * A KMSKeyDetails object that contains:
     * The encryption option for this repository association. It is either owned by Amazon Web Services
     * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
     * The ID of the Amazon Web Services KMS key that
     * is associated with this respository association.
     */
    val kmsKeyDetails: aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails? = builder.kmsKeyDetails
    /**
     * The time, in milliseconds since the epoch, when the repository association was last updated.
     */
    val lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimeStamp
    /**
     * The name of the repository.
     */
    val name: kotlin.String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
     * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
     * For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    val owner: kotlin.String? = builder.owner
    /**
     * The provider type of the repository association.
     */
    val providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = builder.providerType
    /**
     * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
     * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
     */
    val s3RepositoryDetails: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails? = builder.s3RepositoryDetails
    /**
     * The state of the repository association.
     * The valid repository association states are:
     * Associated: The repository
     * association is complete.
     * Associating: CodeGuru Reviewer is:
     * Setting up pull request notifications. This is required
     * for pull requests to trigger a CodeGuru Reviewer review.
     * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
     * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
     * reviews of code in your repository cannot be triggered.
     * Setting up source code access. This is required for CodeGuru Reviewer to securely
     * clone code in your repository.
     * Failed: The repository failed to associate or disassociate.
     * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
     * source code access.
     * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
     * with this repository if you want to review source code in it later. You can control access to code reviews created in an
     * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
     * associated repositories in the Amazon CodeGuru Reviewer User Guide.
     */
    val state: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationState? = builder.state
    /**
     * A description of why the repository association is in the current state.
     */
    val stateReason: kotlin.String? = builder.stateReason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAssociation(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("connectionArn=$connectionArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("kmsKeyDetails=$kmsKeyDetails,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("s3RepositoryDetails=$s3RepositoryDetails,")
        append("state=$state,")
        append("stateReason=$stateReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (s3RepositoryDetails?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryAssociation

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (connectionArn != other.connectionArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (kmsKeyDetails != other.kmsKeyDetails) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (s3RepositoryDetails != other.s3RepositoryDetails) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) identifying the repository association.
         */
        var associationArn: kotlin.String? = null
        /**
         * The ID of the repository association.
         */
        var associationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        var connectionArn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the repository association was created.
         */
        var createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A KMSKeyDetails object that contains:
         * The encryption option for this repository association. It is either owned by Amazon Web Services
         * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
         * The ID of the Amazon Web Services KMS key that
         * is associated with this respository association.
         */
        var kmsKeyDetails: aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails? = null
        /**
         * The time, in milliseconds since the epoch, when the repository association was last updated.
         */
        var lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the repository.
         */
        var name: kotlin.String? = null
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        var owner: kotlin.String? = null
        /**
         * The provider type of the repository association.
         */
        var providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = null
        /**
         * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
         * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         */
        var s3RepositoryDetails: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails? = null
        /**
         * The state of the repository association.
         * The valid repository association states are:
         * Associated: The repository
         * association is complete.
         * Associating: CodeGuru Reviewer is:
         * Setting up pull request notifications. This is required
         * for pull requests to trigger a CodeGuru Reviewer review.
         * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
         * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
         * reviews of code in your repository cannot be triggered.
         * Setting up source code access. This is required for CodeGuru Reviewer to securely
         * clone code in your repository.
         * Failed: The repository failed to associate or disassociate.
         * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
         * source code access.
         * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
         * with this repository if you want to review source code in it later. You can control access to code reviews created in an
         * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
         * associated repositories in the Amazon CodeGuru Reviewer User Guide.
         */
        var state: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationState? = null
        /**
         * A description of why the repository association is in the current state.
         */
        var stateReason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociation) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.connectionArn = x.connectionArn
            this.createdTimeStamp = x.createdTimeStamp
            this.kmsKeyDetails = x.kmsKeyDetails
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.s3RepositoryDetails = x.s3RepositoryDetails
            this.state = x.state
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociation = RepositoryAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails] inside the given [block]
         */
        fun kmsKeyDetails(block: aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails.Builder.() -> kotlin.Unit) {
            this.kmsKeyDetails = aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails] inside the given [block]
         */
        fun s3RepositoryDetails(block: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails.Builder.() -> kotlin.Unit) {
            this.s3RepositoryDetails = aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails.invoke(block)
        }
    }
}
