// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Metadata that is associated with a code review. This applies to both pull request
 * and repository analysis code reviews.
 */
class RequestMetadata private constructor(builder: Builder) {
    /**
     * Information about the event associated with a code review.
     */
    val eventInfo: aws.sdk.kotlin.services.codegurureviewer.model.EventInfo? = builder.eventInfo
    /**
     * The ID of the request. This is required for a pull request code review.
     */
    val requestId: kotlin.String? = builder.requestId
    /**
     * An identifier, such as a name or account ID, that is associated with the requester. The
     * Requester is used to capture the author/actor name of the event request.
     */
    val requester: kotlin.String? = builder.requester
    /**
     * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
     * review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
     * review by GitHub scripts from a GitHub repository, then the repository association's ProviderType is
     * S3Bucket and the CI/CD repository vendor name is GitHub. For more
     * information, see the definition for ProviderType in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation.
     */
    val vendorName: aws.sdk.kotlin.services.codegurureviewer.model.VendorName? = builder.vendorName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestMetadata(")
        append("eventInfo=$eventInfo,")
        append("requestId=$requestId,")
        append("requester=$requester,")
        append("vendorName=$vendorName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventInfo?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (requester?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestMetadata

        if (eventInfo != other.eventInfo) return false
        if (requestId != other.requestId) return false
        if (requester != other.requester) return false
        if (vendorName != other.vendorName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the event associated with a code review.
         */
        var eventInfo: aws.sdk.kotlin.services.codegurureviewer.model.EventInfo? = null
        /**
         * The ID of the request. This is required for a pull request code review.
         */
        var requestId: kotlin.String? = null
        /**
         * An identifier, such as a name or account ID, that is associated with the requester. The
         * Requester is used to capture the author/actor name of the event request.
         */
        var requester: kotlin.String? = null
        /**
         * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
         * review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
         * review by GitHub scripts from a GitHub repository, then the repository association's ProviderType is
         * S3Bucket and the CI/CD repository vendor name is GitHub. For more
         * information, see the definition for ProviderType in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation.
         */
        var vendorName: aws.sdk.kotlin.services.codegurureviewer.model.VendorName? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata) : this() {
            this.eventInfo = x.eventInfo
            this.requestId = x.requestId
            this.requester = x.requester
            this.vendorName = x.vendorName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata = RequestMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.EventInfo] inside the given [block]
         */
        fun eventInfo(block: aws.sdk.kotlin.services.codegurureviewer.model.EventInfo.Builder.() -> kotlin.Unit) {
            this.eventInfo = aws.sdk.kotlin.services.codegurureviewer.model.EventInfo.invoke(block)
        }
    }
}
