// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about an associated repository in an S3 bucket. The associated repository contains a source code
 * .zip file and a build artifacts .zip file that contains .jar or .class files.
 */
class S3BucketRepository private constructor(builder: Builder) {
    /**
     * An S3RepositoryDetails object that specifies the name of an S3 bucket and
     * a CodeArtifacts object. The CodeArtifacts object includes the S3
     * object keys for a source code .zip file and for a build artifacts .zip file.
     */
    val details: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails? = builder.details
    /**
     * The name of the repository when the ProviderType is S3Bucket.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketRepository(")
        append("details=$details,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketRepository

        if (details != other.details) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository = Builder(this).apply(block).build()

    class Builder {
        /**
         * An S3RepositoryDetails object that specifies the name of an S3 bucket and
         * a CodeArtifacts object. The CodeArtifacts object includes the S3
         * object keys for a source code .zip file and for a build artifacts .zip file.
         */
        var details: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails? = null
        /**
         * The name of the repository when the ProviderType is S3Bucket.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository) : this() {
            this.details = x.details
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository = S3BucketRepository(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails] inside the given [block]
         */
        fun details(block: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails.Builder.() -> kotlin.Unit) {
            this.details = aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails.invoke(block)
        }
    }
}
