// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
 * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
 */
class S3RepositoryDetails private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket used for associating a new S3 repository. It must begin with
     * codeguru-reviewer-.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * A CodeArtifacts object. The CodeArtifacts object includes the S3
     * object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
     */
    val codeArtifacts: aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts? = builder.codeArtifacts

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3RepositoryDetails(")
        append("bucketName=$bucketName,")
        append("codeArtifacts=$codeArtifacts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (codeArtifacts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3RepositoryDetails

        if (bucketName != other.bucketName) return false
        if (codeArtifacts != other.codeArtifacts) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the S3 bucket used for associating a new S3 repository. It must begin with
         * codeguru-reviewer-.
         */
        var bucketName: kotlin.String? = null
        /**
         * A CodeArtifacts object. The CodeArtifacts object includes the S3
         * object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         */
        var codeArtifacts: aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails) : this() {
            this.bucketName = x.bucketName
            this.codeArtifacts = x.codeArtifacts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails = S3RepositoryDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts] inside the given [block]
         */
        fun codeArtifacts(block: aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts.Builder.() -> kotlin.Unit) {
            this.codeArtifacts = aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts.invoke(block)
        }
    }
}
