// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Specifies the source code that is analyzed in a code review.
 */
class SourceCodeType private constructor(builder: Builder) {
    /**
     * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that
     * specifies a source branch name and a destination branch name in an associated repository.
     */
    val branchDiff: aws.sdk.kotlin.services.codegurureviewer.model.BranchDiffSourceCodeType? = builder.branchDiff
    /**
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that
     * specifies a commit diff created by a pull request on an associated repository.
     */
    val commitDiff: aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType? = builder.commitDiff
    /**
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that specifies
     * the tip of a branch in an associated repository.
     */
    val repositoryHead: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType? = builder.repositoryHead
    /**
     * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
     * RequestMetadaa field captures any event metadata. For example, it might capture metadata associated with
     * an event trigger, such as a push or a pull request.
     */
    val requestMetadata: aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata? = builder.requestMetadata
    /**
     * Information about an associated repository in an S3 bucket that includes its name and an S3RepositoryDetails object.
     * The S3RepositoryDetails object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
     * an S3 key for a build artifacts .zip file. S3BucketRepository is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * for
     * S3BucketRepository based code reviews.
     */
    val s3BucketRepository: aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository? = builder.s3BucketRepository

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceCodeType(")
        append("branchDiff=$branchDiff,")
        append("commitDiff=$commitDiff,")
        append("repositoryHead=$repositoryHead,")
        append("requestMetadata=$requestMetadata,")
        append("s3BucketRepository=$s3BucketRepository)")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchDiff?.hashCode() ?: 0
        result = 31 * result + (commitDiff?.hashCode() ?: 0)
        result = 31 * result + (repositoryHead?.hashCode() ?: 0)
        result = 31 * result + (requestMetadata?.hashCode() ?: 0)
        result = 31 * result + (s3BucketRepository?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceCodeType

        if (branchDiff != other.branchDiff) return false
        if (commitDiff != other.commitDiff) return false
        if (repositoryHead != other.repositoryHead) return false
        if (requestMetadata != other.requestMetadata) return false
        if (s3BucketRepository != other.s3BucketRepository) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType = Builder(this).apply(block).build()

    class Builder {
        /**
         * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies a source branch name and a destination branch name in an associated repository.
         */
        var branchDiff: aws.sdk.kotlin.services.codegurureviewer.model.BranchDiffSourceCodeType? = null
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies a commit diff created by a pull request on an associated repository.
         */
        var commitDiff: aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType? = null
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that specifies
         * the tip of a branch in an associated repository.
         */
        var repositoryHead: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType? = null
        /**
         * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
         * RequestMetadaa field captures any event metadata. For example, it might capture metadata associated with
         * an event trigger, such as a push or a pull request.
         */
        var requestMetadata: aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata? = null
        /**
         * Information about an associated repository in an S3 bucket that includes its name and an S3RepositoryDetails object.
         * The S3RepositoryDetails object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
         * an S3 key for a build artifacts .zip file. S3BucketRepository is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * for
         * S3BucketRepository based code reviews.
         */
        var s3BucketRepository: aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType) : this() {
            this.branchDiff = x.branchDiff
            this.commitDiff = x.commitDiff
            this.repositoryHead = x.repositoryHead
            this.requestMetadata = x.requestMetadata
            this.s3BucketRepository = x.s3BucketRepository
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType = SourceCodeType(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.BranchDiffSourceCodeType] inside the given [block]
         */
        fun branchDiff(block: aws.sdk.kotlin.services.codegurureviewer.model.BranchDiffSourceCodeType.Builder.() -> kotlin.Unit) {
            this.branchDiff = aws.sdk.kotlin.services.codegurureviewer.model.BranchDiffSourceCodeType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType] inside the given [block]
         */
        fun commitDiff(block: aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType.Builder.() -> kotlin.Unit) {
            this.commitDiff = aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType] inside the given [block]
         */
        fun repositoryHead(block: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType.Builder.() -> kotlin.Unit) {
            this.repositoryHead = aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata] inside the given [block]
         */
        fun requestMetadata(block: aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata.Builder.() -> kotlin.Unit) {
            this.requestMetadata = aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository] inside the given [block]
         */
        fun s3BucketRepository(block: aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository.Builder.() -> kotlin.Unit) {
            this.s3BucketRepository = aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository.invoke(block)
        }
    }
}
