// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object.
     * You can retrieve this ARN by calling
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * ListRepositoryAssociations
     * .
     */
    val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
     * A tag key (for example, CostCenter,
     * Environment, Project, or Secret). Tag
     * keys are case sensitive.
     * An optional field known as a tag value (for example,
     * 111122223333, Production, or a team name).
     * Omitting the tag value is the same as using an empty string. Like tag keys, tag
     * values are case sensitive.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.TagResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        var resourceArn: kotlin.String? = null
        /**
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
         * A tag key (for example, CostCenter,
         * Environment, Project, or Secret). Tag
         * keys are case sensitive.
         * An optional field known as a tag value (for example,
         * 111122223333, Production, or a team name).
         * Omitting the tag value is the same as using an empty string. Like tag keys, tag
         * values are case sensitive.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.TagResourceRequest = TagResourceRequest(this)
    }
}
