// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about a third-party source repository connected to CodeGuru Reviewer.
 */
class ThirdPartySourceRepository private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
     * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
     * Connection
     * in
     * the Amazon Web Services CodeStar Connections API Reference.
     */
    val connectionArn: kotlin.String? = builder.connectionArn
    /**
     * The name of the third party source repository.
     */
    val name: kotlin.String? = builder.name
    /**
     * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
     * this is the username for the account that owns the repository. For an S3 repository,
     * this can be the username or Amazon Web Services account ID.
     */
    val owner: kotlin.String? = builder.owner

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThirdPartySourceRepository(")
        append("connectionArn=$connectionArn,")
        append("name=$name,")
        append("owner=$owner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionArn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThirdPartySourceRepository

        if (connectionArn != other.connectionArn) return false
        if (name != other.name) return false
        if (owner != other.owner) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        var connectionArn: kotlin.String? = null
        /**
         * The name of the third party source repository.
         */
        var name: kotlin.String? = null
        /**
         * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
         * this is the username for the account that owns the repository. For an S3 repository,
         * this can be the username or Amazon Web Services account ID.
         */
        var owner: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository) : this() {
            this.connectionArn = x.connectionArn
            this.name = x.name
            this.owner = x.owner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository = ThirdPartySourceRepository(this)
    }
}
