// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codegurureviewer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codegurureviewer.model.*
import aws.sdk.kotlin.services.codegurureviewer.model.AssociateRepositoryRequest
import aws.sdk.kotlin.services.codegurureviewer.model.AssociateRepositoryResponse
import aws.sdk.kotlin.services.codegurureviewer.model.CreateCodeReviewRequest
import aws.sdk.kotlin.services.codegurureviewer.model.CreateCodeReviewResponse
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeCodeReviewRequest
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeCodeReviewResponse
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeRepositoryAssociationRequest
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeRepositoryAssociationResponse
import aws.sdk.kotlin.services.codegurureviewer.model.DisassociateRepositoryRequest
import aws.sdk.kotlin.services.codegurureviewer.model.DisassociateRepositoryResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListCodeReviewsRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListCodeReviewsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationsRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codegurureviewer.model.PutRecommendationFeedbackRequest
import aws.sdk.kotlin.services.codegurureviewer.model.PutRecommendationFeedbackResponse
import aws.sdk.kotlin.services.codegurureviewer.model.TagResourceRequest
import aws.sdk.kotlin.services.codegurureviewer.model.TagResourceResponse
import aws.sdk.kotlin.services.codegurureviewer.model.UntagResourceRequest
import aws.sdk.kotlin.services.codegurureviewer.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This section provides documentation for the Amazon CodeGuru Reviewer API operations. CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java and Python code.
 *
 * By proactively detecting and providing recommendations for addressing code defects and implementing best practices, CodeGuru Reviewer improves the overall quality and maintainability of your code base during the code review stage. For more information about CodeGuru Reviewer, see the *[Amazon CodeGuru Reviewer User Guide](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/welcome.html).*
 *
 *  To improve the security of your CodeGuru Reviewer API calls, you can establish a private connection between your VPC and CodeGuru Reviewer by creating an *interface VPC endpoint*. For more information, see [CodeGuru Reviewer and interface VPC endpoints (Amazon Web Services PrivateLink)](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/vpc-interface-endpoints.html) in the *Amazon CodeGuru Reviewer User Guide*.
 */
public interface CodeGuruReviewerClient : SdkClient {

    override val serviceName: String
        get() = "CodeGuru Reviewer"
    /**
     * CodeGuruReviewerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CodeGuruReviewerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeGuruReviewerClient(config)
        }

        public operator fun invoke(config: Config): CodeGuruReviewerClient = DefaultCodeGuruReviewerClient(config)

        /**
         * Construct a [CodeGuruReviewerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeGuruReviewerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCodeGuruReviewerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Use to associate an Amazon Web Services CodeCommit repository or a repostory managed by Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see [Recommendations in Amazon CodeGuru Reviewer](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html) in the *Amazon CodeGuru Reviewer User Guide.*
     *
     * If you associate a CodeCommit or S3 repository, it must be in the same Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
     *
     * Bitbucket and GitHub Enterprise Server repositories are managed by Amazon Web Services CodeStar Connections to connect to CodeGuru Reviewer. For more information, see [Associate a repository](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-associate-repository.html) in the *Amazon CodeGuru Reviewer User Guide.*
     *
     *  You cannot use the CodeGuru Reviewer SDK or the Amazon Web Services CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate a GitHub repository, use the console. For more information, see [Getting started with CodeGuru Reviewer](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html) in the *CodeGuru Reviewer User Guide.*
     */
    public suspend fun associateRepository(input: AssociateRepositoryRequest): AssociateRepositoryResponse

    /**
     * Use to create a code review with a `CodeReviewType`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html) of `RepositoryAnalysis`. This type of code review analyzes all code under a specified branch in an associated repository. `PullRequest` code reviews are automatically triggered by a pull request.
     */
    public suspend fun createCodeReview(input: CreateCodeReviewRequest): CreateCodeReviewResponse

    /**
     * Returns the metadata associated with the code review along with its status.
     */
    public suspend fun describeCodeReview(input: DescribeCodeReviewRequest): DescribeCodeReviewResponse

    /**
     * Describes the customer feedback for a CodeGuru Reviewer recommendation.
     */
    public suspend fun describeRecommendationFeedback(input: DescribeRecommendationFeedbackRequest): DescribeRecommendationFeedbackResponse

    /**
     * Returns a `RepositoryAssociation`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object that contains information about the requested repository association.
     */
    public suspend fun describeRepositoryAssociation(input: DescribeRepositoryAssociationRequest): DescribeRepositoryAssociationResponse

    /**
     * Removes the association between Amazon CodeGuru Reviewer and a repository.
     */
    public suspend fun disassociateRepository(input: DisassociateRepositoryRequest): DisassociateRepositoryResponse

    /**
     * Lists all the code reviews that the customer has created in the past 90 days.
     */
    public suspend fun listCodeReviews(input: ListCodeReviewsRequest): ListCodeReviewsResponse

    /**
     * Returns a list of `RecommendationFeedbackSummary`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html) objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
     */
    public suspend fun listRecommendationFeedback(input: ListRecommendationFeedbackRequest): ListRecommendationFeedbackResponse

    /**
     * Returns the list of all recommendations for a completed code review.
     */
    public suspend fun listRecommendations(input: ListRecommendationsRequest): ListRecommendationsResponse

    /**
     * Returns a list of `RepositoryAssociationSummary`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html) objects that contain summary information about a repository association. You can filter the returned list by `ProviderType`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType), `Name`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name), `State`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State), and `Owner`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner).
     */
    public suspend fun listRepositoryAssociations(input: ListRepositoryAssociationsRequest = ListRepositoryAssociationsRequest {}): ListRepositoryAssociationsResponse

    /**
     * Returns the list of tags associated with an associated repository resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
     */
    public suspend fun putRecommendationFeedback(input: PutRecommendationFeedbackRequest): PutRecommendationFeedbackResponse

    /**
     * Adds one or more tags to an associated repository.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from an associated repository.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Use to associate an Amazon Web Services CodeCommit repository or a repostory managed by Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see [Recommendations in Amazon CodeGuru Reviewer](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html) in the *Amazon CodeGuru Reviewer User Guide.*
 *
 * If you associate a CodeCommit or S3 repository, it must be in the same Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
 *
 * Bitbucket and GitHub Enterprise Server repositories are managed by Amazon Web Services CodeStar Connections to connect to CodeGuru Reviewer. For more information, see [Associate a repository](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-associate-repository.html) in the *Amazon CodeGuru Reviewer User Guide.*
 *
 *  You cannot use the CodeGuru Reviewer SDK or the Amazon Web Services CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate a GitHub repository, use the console. For more information, see [Getting started with CodeGuru Reviewer](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html) in the *CodeGuru Reviewer User Guide.*
 */
public suspend inline fun CodeGuruReviewerClient.associateRepository(crossinline block: AssociateRepositoryRequest.Builder.() -> Unit): AssociateRepositoryResponse = associateRepository(AssociateRepositoryRequest.Builder().apply(block).build())

/**
 * Use to create a code review with a `CodeReviewType`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html) of `RepositoryAnalysis`. This type of code review analyzes all code under a specified branch in an associated repository. `PullRequest` code reviews are automatically triggered by a pull request.
 */
public suspend inline fun CodeGuruReviewerClient.createCodeReview(crossinline block: CreateCodeReviewRequest.Builder.() -> Unit): CreateCodeReviewResponse = createCodeReview(CreateCodeReviewRequest.Builder().apply(block).build())

/**
 * Returns the metadata associated with the code review along with its status.
 */
public suspend inline fun CodeGuruReviewerClient.describeCodeReview(crossinline block: DescribeCodeReviewRequest.Builder.() -> Unit): DescribeCodeReviewResponse = describeCodeReview(DescribeCodeReviewRequest.Builder().apply(block).build())

/**
 * Describes the customer feedback for a CodeGuru Reviewer recommendation.
 */
public suspend inline fun CodeGuruReviewerClient.describeRecommendationFeedback(crossinline block: DescribeRecommendationFeedbackRequest.Builder.() -> Unit): DescribeRecommendationFeedbackResponse = describeRecommendationFeedback(DescribeRecommendationFeedbackRequest.Builder().apply(block).build())

/**
 * Returns a `RepositoryAssociation`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object that contains information about the requested repository association.
 */
public suspend inline fun CodeGuruReviewerClient.describeRepositoryAssociation(crossinline block: DescribeRepositoryAssociationRequest.Builder.() -> Unit): DescribeRepositoryAssociationResponse = describeRepositoryAssociation(DescribeRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Removes the association between Amazon CodeGuru Reviewer and a repository.
 */
public suspend inline fun CodeGuruReviewerClient.disassociateRepository(crossinline block: DisassociateRepositoryRequest.Builder.() -> Unit): DisassociateRepositoryResponse = disassociateRepository(DisassociateRepositoryRequest.Builder().apply(block).build())

/**
 * Lists all the code reviews that the customer has created in the past 90 days.
 */
public suspend inline fun CodeGuruReviewerClient.listCodeReviews(crossinline block: ListCodeReviewsRequest.Builder.() -> Unit): ListCodeReviewsResponse = listCodeReviews(ListCodeReviewsRequest.Builder().apply(block).build())

/**
 * Returns a list of `RecommendationFeedbackSummary`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html) objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
 */
public suspend inline fun CodeGuruReviewerClient.listRecommendationFeedback(crossinline block: ListRecommendationFeedbackRequest.Builder.() -> Unit): ListRecommendationFeedbackResponse = listRecommendationFeedback(ListRecommendationFeedbackRequest.Builder().apply(block).build())

/**
 * Returns the list of all recommendations for a completed code review.
 */
public suspend inline fun CodeGuruReviewerClient.listRecommendations(crossinline block: ListRecommendationsRequest.Builder.() -> Unit): ListRecommendationsResponse = listRecommendations(ListRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns a list of `RepositoryAssociationSummary`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html) objects that contain summary information about a repository association. You can filter the returned list by `ProviderType`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType), `Name`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name), `State`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State), and `Owner`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner).
 */
public suspend inline fun CodeGuruReviewerClient.listRepositoryAssociations(crossinline block: ListRepositoryAssociationsRequest.Builder.() -> Unit): ListRepositoryAssociationsResponse = listRepositoryAssociations(ListRepositoryAssociationsRequest.Builder().apply(block).build())

/**
 * Returns the list of tags associated with an associated repository resource.
 */
public suspend inline fun CodeGuruReviewerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
 */
public suspend inline fun CodeGuruReviewerClient.putRecommendationFeedback(crossinline block: PutRecommendationFeedbackRequest.Builder.() -> Unit): PutRecommendationFeedbackResponse = putRecommendationFeedback(PutRecommendationFeedbackRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an associated repository.
 */
public suspend inline fun CodeGuruReviewerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from an associated repository.
 */
public suspend inline fun CodeGuruReviewerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
