// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a code review. A code review belongs to the associated repository that contains the reviewed code.
 */
public class CodeReview private constructor(builder: Builder) {
    /**
     * The types of analysis performed during a repository analysis or a pull request review. You can specify either `Security`, `CodeQuality`, or both.
     */
    public val analysisTypes: List<AnalysisType>? = builder.analysisTypes
    /**
     * The Amazon Resource Name (ARN) of the `RepositoryAssociation`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) that contains the reviewed source code. You can retrieve associated repository ARNs by calling `ListRepositoryAssociations`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
     */
    public val associationArn: kotlin.String? = builder.associationArn
    /**
     * The Amazon Resource Name (ARN) of the `CodeReview`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
     */
    public val codeReviewArn: kotlin.String? = builder.codeReviewArn
    /**
     * The state of the `aws-codeguru-reviewer.yml` configuration file that allows the configuration of the CodeGuru Reviewer analysis. The file either exists, doesn't exist, or exists with errors at the root directory of your repository.
     */
    public val configFileState: aws.sdk.kotlin.services.codegurureviewer.model.ConfigFileState? = builder.configFileState
    /**
     * The time, in milliseconds since the epoch, when the code review was created.
     */
    public val createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimeStamp
    /**
     * The time, in milliseconds since the epoch, when the code review was last updated.
     */
    public val lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimeStamp
    /**
     * The statistics from the code review.
     */
    public val metrics: aws.sdk.kotlin.services.codegurureviewer.model.Metrics? = builder.metrics
    /**
     * The name of the code review.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
     */
    public val providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = builder.providerType
    /**
     * The pull request ID for the code review.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId
    /**
     * The name of the repository.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The type of the source code for the code review.
     */
    public val sourceCodeType: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType? = builder.sourceCodeType
    /**
     * The valid code review states are:
     * + `Completed`: The code review is complete.
     * + `Pending`: The code review started and has not completed or failed.
     * + `Failed`: The code review failed.
     * + `Deleting`: The code review is being deleted.
     */
    public val state: aws.sdk.kotlin.services.codegurureviewer.model.JobState? = builder.state
    /**
     * The reason for the state of the code review.
     */
    public val stateReason: kotlin.String? = builder.stateReason
    /**
     * The type of code review.
     */
    public val type: aws.sdk.kotlin.services.codegurureviewer.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CodeReview = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeReview(")
        append("analysisTypes=$analysisTypes,")
        append("associationArn=$associationArn,")
        append("codeReviewArn=$codeReviewArn,")
        append("configFileState=$configFileState,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("metrics=$metrics,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("pullRequestId=$pullRequestId,")
        append("repositoryName=$repositoryName,")
        append("sourceCodeType=$sourceCodeType,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisTypes?.hashCode() ?: 0
        result = 31 * result + (associationArn?.hashCode() ?: 0)
        result = 31 * result + (codeReviewArn?.hashCode() ?: 0)
        result = 31 * result + (configFileState?.hashCode() ?: 0)
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeReview

        if (analysisTypes != other.analysisTypes) return false
        if (associationArn != other.associationArn) return false
        if (codeReviewArn != other.codeReviewArn) return false
        if (configFileState != other.configFileState) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (metrics != other.metrics) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (pullRequestId != other.pullRequestId) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCodeType != other.sourceCodeType) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CodeReview = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The types of analysis performed during a repository analysis or a pull request review. You can specify either `Security`, `CodeQuality`, or both.
         */
        public var analysisTypes: List<AnalysisType>? = null
        /**
         * The Amazon Resource Name (ARN) of the `RepositoryAssociation`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) that contains the reviewed source code. You can retrieve associated repository ARNs by calling `ListRepositoryAssociations`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
         */
        public var associationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the `CodeReview`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
         */
        public var codeReviewArn: kotlin.String? = null
        /**
         * The state of the `aws-codeguru-reviewer.yml` configuration file that allows the configuration of the CodeGuru Reviewer analysis. The file either exists, doesn't exist, or exists with errors at the root directory of your repository.
         */
        public var configFileState: aws.sdk.kotlin.services.codegurureviewer.model.ConfigFileState? = null
        /**
         * The time, in milliseconds since the epoch, when the code review was created.
         */
        public var createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in milliseconds since the epoch, when the code review was last updated.
         */
        public var lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistics from the code review.
         */
        public var metrics: aws.sdk.kotlin.services.codegurureviewer.model.Metrics? = null
        /**
         * The name of the code review.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        public var owner: kotlin.String? = null
        /**
         * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         */
        public var providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = null
        /**
         * The pull request ID for the code review.
         */
        public var pullRequestId: kotlin.String? = null
        /**
         * The name of the repository.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The type of the source code for the code review.
         */
        public var sourceCodeType: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType? = null
        /**
         * The valid code review states are:
         * + `Completed`: The code review is complete.
         * + `Pending`: The code review started and has not completed or failed.
         * + `Failed`: The code review failed.
         * + `Deleting`: The code review is being deleted.
         */
        public var state: aws.sdk.kotlin.services.codegurureviewer.model.JobState? = null
        /**
         * The reason for the state of the code review.
         */
        public var stateReason: kotlin.String? = null
        /**
         * The type of code review.
         */
        public var type: aws.sdk.kotlin.services.codegurureviewer.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CodeReview) : this() {
            this.analysisTypes = x.analysisTypes
            this.associationArn = x.associationArn
            this.codeReviewArn = x.codeReviewArn
            this.configFileState = x.configFileState
            this.createdTimeStamp = x.createdTimeStamp
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.metrics = x.metrics
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.pullRequestId = x.pullRequestId
            this.repositoryName = x.repositoryName
            this.sourceCodeType = x.sourceCodeType
            this.state = x.state
            this.stateReason = x.stateReason
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CodeReview = CodeReview(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.Metrics] inside the given [block]
         */
        public fun metrics(block: aws.sdk.kotlin.services.codegurureviewer.model.Metrics.Builder.() -> kotlin.Unit) {
            this.metrics = aws.sdk.kotlin.services.codegurureviewer.model.Metrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType] inside the given [block]
         */
        public fun sourceCodeType(block: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType.Builder.() -> kotlin.Unit) {
            this.sourceCodeType = aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType.invoke(block)
        }
    }
}
