// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



public class CreateCodeReviewRequest private constructor(builder: Builder) {
    /**
     * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the `RepositoryAssociation`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object. You can retrieve this ARN by calling `ListRepositoryAssociations`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
     *
     *  A code review can only be created on an associated repository. This is the ARN of the associated repository.
     */
    public val repositoryAssociationArn: kotlin.String? = builder.repositoryAssociationArn
    /**
     * The type of code review to create. This is specified using a `CodeReviewType`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html) object. You can create a code review only of type `RepositoryAnalysis`.
     */
    public val type: aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CreateCodeReviewRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCodeReviewRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("name=$name,")
        append("repositoryAssociationArn=$repositoryAssociationArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (repositoryAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCodeReviewRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (name != other.name) return false
        if (repositoryAssociationArn != other.repositoryAssociationArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CreateCodeReviewRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the `RepositoryAssociation`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object. You can retrieve this ARN by calling `ListRepositoryAssociations`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
         *
         *  A code review can only be created on an associated repository. This is the ARN of the associated repository.
         */
        public var repositoryAssociationArn: kotlin.String? = null
        /**
         * The type of code review to create. This is specified using a `CodeReviewType`[](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html) object. You can create a code review only of type `RepositoryAnalysis`.
         */
        public var type: aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CreateCodeReviewRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.name = x.name
            this.repositoryAssociationArn = x.repositoryAssociationArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CreateCodeReviewRequest = CreateCodeReviewRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType] inside the given [block]
         */
        public fun type(block: aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType.Builder.() -> kotlin.Unit) {
            this.type = aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType.invoke(block)
        }
    }
}
