// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.paginators

import aws.sdk.kotlin.services.codegurureviewer.CodeGuruReviewerClient
import aws.sdk.kotlin.services.codegurureviewer.model.ListCodeReviewsRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListCodeReviewsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationsRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsRequest
import aws.sdk.kotlin.services.codegurureviewer.model.ListRepositoryAssociationsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCodeReviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCodeReviewsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCodeReviewsResponse]
 */
public fun CodeGuruReviewerClient.listCodeReviewsPaginated(initialRequest: ListCodeReviewsRequest): Flow<ListCodeReviewsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCodeReviewsPaginated.listCodeReviews(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCodeReviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCodeReviewsResponse]
 */
public fun CodeGuruReviewerClient.listCodeReviewsPaginated(block: ListCodeReviewsRequest.Builder.() -> Unit): Flow<ListCodeReviewsResponse> =
    listCodeReviewsPaginated(ListCodeReviewsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRecommendationFeedbackResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecommendationFeedbackRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationFeedbackResponse]
 */
public fun CodeGuruReviewerClient.listRecommendationFeedbackPaginated(initialRequest: ListRecommendationFeedbackRequest): Flow<ListRecommendationFeedbackResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecommendationFeedbackPaginated.listRecommendationFeedback(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecommendationFeedbackResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationFeedbackResponse]
 */
public fun CodeGuruReviewerClient.listRecommendationFeedbackPaginated(block: ListRecommendationFeedbackRequest.Builder.() -> Unit): Flow<ListRecommendationFeedbackResponse> =
    listRecommendationFeedbackPaginated(ListRecommendationFeedbackRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecommendationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationsResponse]
 */
public fun CodeGuruReviewerClient.listRecommendationsPaginated(initialRequest: ListRecommendationsRequest): Flow<ListRecommendationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecommendationsPaginated.listRecommendations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendationsResponse]
 */
public fun CodeGuruReviewerClient.listRecommendationsPaginated(block: ListRecommendationsRequest.Builder.() -> Unit): Flow<ListRecommendationsResponse> =
    listRecommendationsPaginated(ListRecommendationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRepositoryAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoryAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoryAssociationsResponse]
 */
public fun CodeGuruReviewerClient.listRepositoryAssociationsPaginated(initialRequest: ListRepositoryAssociationsRequest): Flow<ListRepositoryAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoryAssociationsPaginated.listRepositoryAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoryAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoryAssociationsResponse]
 */
public fun CodeGuruReviewerClient.listRepositoryAssociationsPaginated(block: ListRepositoryAssociationsRequest.Builder.() -> Unit): Flow<ListRepositoryAssociationsResponse> =
    listRepositoryAssociationsPaginated(ListRepositoryAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositoryAssociationsPaginated]
 * to access the nested member [RepositoryAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositoryAssociationSummary]
 */
@JvmName("listRepositoryAssociationsResponseRepositoryAssociationSummary")
public fun Flow<ListRepositoryAssociationsResponse>.repositoryAssociationSummaries(): Flow<RepositoryAssociationSummary> =
    transform() { response ->
        response.repositoryAssociationSummaries?.forEach {
            emit(it)
        }
    }
