// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about metrics summaries.
 */
public class MetricsSummary private constructor(builder: Builder) {
    /**
     * Total number of recommendations found in the code review.
     */
    public val findingsCount: kotlin.Long? = builder.findingsCount
    /**
     * Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions, this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files, `MeteredLinesOfCodeCount` includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of code for a total of 2,725 lines of code.
     */
    public val meteredLinesOfCodeCount: kotlin.Long? = builder.meteredLinesOfCodeCount
    /**
     * Lines of code suppressed in the code review based on the `excludeFiles` element in the `aws-codeguru-reviewer.yml` file. For full repository analyses, this number includes all lines of code in the files that are suppressed. For pull requests, this number only includes the *changed* lines of code that are suppressed. In both cases, this number does not include non-code lines such as comments and import statements. For example, if you initiate a full repository analysis on a repository containing 5 files, each file with 100 lines of code, and 2 files are listed as excluded in the `aws-codeguru-reviewer.yml` file, then `SuppressedLinesOfCodeCount` returns 200 (2 * 100) as the total number of lines of code suppressed. However, if you submit a pull request for the same repository, then `SuppressedLinesOfCodeCount` only includes the lines in the 2 files that changed. If only 1 of the 2 files changed in the pull request, then `SuppressedLinesOfCodeCount` returns 100 (1 * 100) as the total number of lines of code suppressed.
     */
    public val suppressedLinesOfCodeCount: kotlin.Long? = builder.suppressedLinesOfCodeCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricsSummary(")
        append("findingsCount=$findingsCount,")
        append("meteredLinesOfCodeCount=$meteredLinesOfCodeCount,")
        append("suppressedLinesOfCodeCount=$suppressedLinesOfCodeCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = findingsCount?.hashCode() ?: 0
        result = 31 * result + (meteredLinesOfCodeCount?.hashCode() ?: 0)
        result = 31 * result + (suppressedLinesOfCodeCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricsSummary

        if (findingsCount != other.findingsCount) return false
        if (meteredLinesOfCodeCount != other.meteredLinesOfCodeCount) return false
        if (suppressedLinesOfCodeCount != other.suppressedLinesOfCodeCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Total number of recommendations found in the code review.
         */
        public var findingsCount: kotlin.Long? = null
        /**
         * Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions, this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files, `MeteredLinesOfCodeCount` includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of code for a total of 2,725 lines of code.
         */
        public var meteredLinesOfCodeCount: kotlin.Long? = null
        /**
         * Lines of code suppressed in the code review based on the `excludeFiles` element in the `aws-codeguru-reviewer.yml` file. For full repository analyses, this number includes all lines of code in the files that are suppressed. For pull requests, this number only includes the *changed* lines of code that are suppressed. In both cases, this number does not include non-code lines such as comments and import statements. For example, if you initiate a full repository analysis on a repository containing 5 files, each file with 100 lines of code, and 2 files are listed as excluded in the `aws-codeguru-reviewer.yml` file, then `SuppressedLinesOfCodeCount` returns 200 (2 * 100) as the total number of lines of code suppressed. However, if you submit a pull request for the same repository, then `SuppressedLinesOfCodeCount` only includes the lines in the 2 files that changed. If only 1 of the 2 files changed in the pull request, then `SuppressedLinesOfCodeCount` returns 100 (1 * 100) as the total number of lines of code suppressed.
         */
        public var suppressedLinesOfCodeCount: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary) : this() {
            this.findingsCount = x.findingsCount
            this.meteredLinesOfCodeCount = x.meteredLinesOfCodeCount
            this.suppressedLinesOfCodeCount = x.suppressedLinesOfCodeCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary = MetricsSummary(this)
    }
}
